/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.writing.GeneratedImplementation;
import dagger.internal.codegen.writing.PerGeneratedFile;
import dagger.internal.codegen.writing.TopLevel;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@PerGeneratedFile
public final class ComponentWrapperImplementation
implements GeneratedImplementation {
    private final BindingGraph graph;
    private final XClassName name;
    private final UniqueNameSet componentClassNames = new UniqueNameSet();
    private final ListMultimap<ComponentImplementation.FieldSpecKind, XPropertySpec> fieldSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<ComponentImplementation.MethodSpecKind, XFunSpec> methodSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<ComponentImplementation.TypeSpecKind, XTypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(ComponentImplementation.TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<XTypeSpec>> typeSuppliers = new ArrayList<Supplier<XTypeSpec>>();

    @Inject
    ComponentWrapperImplementation(@TopLevel BindingGraph graph) {
        this.graph = graph;
        this.name = ComponentNames.getTopLevelClassName(graph.componentDescriptor());
    }

    @Override
    public XClassName name() {
        return this.name;
    }

    @Override
    public String getUniqueClassName(String name) {
        return this.componentClassNames.getUniqueName(name);
    }

    @Override
    public void addField(ComponentImplementation.FieldSpecKind fieldKind, XPropertySpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    @Override
    public void addMethod(ComponentImplementation.MethodSpecKind methodKind, XFunSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    @Override
    public void addType(ComponentImplementation.TypeSpecKind typeKind, XTypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    @Override
    public void addTypeSupplier(Supplier<XTypeSpec> typeSpecSupplier) {
        this.typeSuppliers.add(typeSpecSupplier);
    }

    @Override
    public XTypeSpec generate() {
        XTypeSpecs.Builder builder = XTypeSpecs.classBuilder(ComponentNames.getTopLevelClassName(this.graph.componentDescriptor())).addModifiers(Modifier.FINAL);
        if (this.graph.componentTypeElement().isPublic()) {
            builder.addModifiers(Modifier.PUBLIC);
        }
        this.fieldSpecsMap.asMap().values().forEach(builder::addProperties);
        this.methodSpecsMap.asMap().values().forEach(builder::addFunctions);
        this.typeSpecsMap.asMap().values().forEach(builder::addTypes);
        this.typeSuppliers.stream().map(Supplier::get).forEach(builder::addType);
        return builder.addFunction(XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).build()).build();
    }
}

