/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.List;

final class AssistedInjectionParameters {
    public static ImmutableList<XParameterSpec> assistedFactoryParameterSpecs(Binding binding, ComponentImplementation.ShardImplementation shardImplementation) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        XTypeElement factory = XElements.asTypeElement(binding.bindingElement().get());
        AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.getType());
        XMethodType factoryMethodType = metadata.factoryMethod().asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionParameters.assistedParameterSpecs((List)metadata.assistedFactoryAssistedParameters().stream().map(arg_0 -> metadata.assistedInjectAssistedParametersMap().get(arg_0)).collect(DaggerStreams.toImmutableList()), factoryMethodType.getParameterTypes(), shardImplementation);
    }

    public static ImmutableList<XParameterSpec> assistedParameterSpecs(Binding binding, ComponentImplementation.ShardImplementation shardImplementation) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        XConstructorElement constructor = XElements.asConstructor(binding.bindingElement().get());
        XConstructorType constructorType = constructor.asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionParameters.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes(), shardImplementation);
    }

    private static ImmutableList<XParameterSpec> assistedParameterSpecs(List<XExecutableParameterElement> paramElements, List<XType> paramTypes, ComponentImplementation.ShardImplementation shardImplementation) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            XExecutableParameterElement paramElement = paramElements.get(i);
            XType paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)XParameterSpecs.of(shardImplementation.getUniqueFieldNameForAssistedParam(paramElement), paramType.asTypeName()));
        }
        return assistedParameterSpecs.build();
    }

    private AssistedInjectionParameters() {
    }
}

