/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.ValidationReport;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.MapKeyValidator;
import dagger.internal.codegen.writing.AnnotationCreatorGenerator;
import dagger.internal.codegen.writing.UnwrappedMapKeyGenerator;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import javax.inject.Inject;

final class MapKeyProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final MapKeyValidator mapKeyValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;
    private final UnwrappedMapKeyGenerator unwrappedMapKeyGenerator;

    @Inject
    MapKeyProcessingStep(MapKeyValidator mapKeyValidator, AnnotationCreatorGenerator annotationCreatorGenerator, UnwrappedMapKeyGenerator unwrappedMapKeyGenerator) {
        this.mapKeyValidator = mapKeyValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
        this.unwrappedMapKeyGenerator = unwrappedMapKeyGenerator;
    }

    public ImmutableSet<XClassName> annotationClassNames() {
        return ImmutableSet.of((Object)XTypeNames.MAP_KEY);
    }

    @Override
    protected void process(XTypeElement mapAnnotation, ImmutableSet<XClassName> annotations) {
        ValidationReport mapKeyReport = this.mapKeyValidator.validate(mapAnnotation);
        mapKeyReport.printMessagesTo(this.messager);
        if (mapKeyReport.isClean()) {
            if (!mapAnnotation.getAnnotation(XTypeNames.MAP_KEY).getAsBoolean("unwrapValue")) {
                this.annotationCreatorGenerator.generate(mapAnnotation, this.messager);
            } else if (this.isAnnotationType(MapKeys.getUnwrappedMapKeyType(mapAnnotation.getType()))) {
                this.unwrappedMapKeyGenerator.generate(mapAnnotation, this.messager);
            }
        }
    }

    private boolean isAnnotationType(XType type) {
        return XTypes.isDeclared(type) && type.getTypeElement().isAnnotationClass();
    }
}

