/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;

final class InjectionSiteFactory {
    private final DependencyRequestFactory dependencyRequestFactory;

    @Inject
    InjectionSiteFactory(DependencyRequestFactory dependencyRequestFactory) {
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    ImmutableSortedSet<MembersInjectionBinding.InjectionSite> getInjectionSites(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared(type));
        HashSet injectionSites = new HashSet();
        InjectionSiteVisitor injectionSiteVisitor = new InjectionSiteVisitor();
        HashMap<XTypeElement, Integer> enclosingTypeElementOrder = new HashMap<XTypeElement, Integer>();
        HashMap enclosedElementOrder = new HashMap();
        Optional<XType> currentType = Optional.of(type);
        while (currentType.isPresent()) {
            XTypeElement typeElement = currentType.get().getTypeElement();
            enclosingTypeElementOrder.put(typeElement, enclosingTypeElementOrder.size());
            for (XElement enclosedElement : typeElement.getEnclosedElements()) {
                injectionSiteVisitor.visit(enclosedElement, currentType.get()).ifPresent(injectionSite -> {
                    enclosedElementOrder.put(enclosedElement, enclosedElementOrder.size());
                    injectionSites.add(injectionSite);
                });
            }
            currentType = XTypes.nonObjectSuperclass(currentType.get());
        }
        return ImmutableSortedSet.copyOf(Comparator.comparing(MembersInjectionBinding.InjectionSite::enclosingTypeElement, Comparator.comparing(enclosingTypeElementOrder::get).reversed()).thenComparing(MembersInjectionBinding.InjectionSite::kind).thenComparing(MembersInjectionBinding.InjectionSite::element, Comparator.comparing(enclosedElementOrder::get)), injectionSites);
    }

    private final class InjectionSiteVisitor {
        private final SetMultimap<String, XMethodElement> subclassMethodMap = LinkedHashMultimap.create();

        private InjectionSiteVisitor() {
        }

        public Optional<MembersInjectionBinding.InjectionSite> visit(XElement element, XType container) {
            if (XElementKt.isMethod(element)) {
                return this.visitMethod(XElements.asMethod(element), container);
            }
            if (XElementKt.isField(element)) {
                return this.visitField(XElements.asField(element), container);
            }
            return Optional.empty();
        }

        public Optional<MembersInjectionBinding.InjectionSite> visitMethod(XMethodElement method, XType container) {
            this.subclassMethodMap.put((Object)XElements.getSimpleName(method), (Object)method);
            if (!this.shouldBeInjected(method)) {
                return Optional.empty();
            }
            XTypeElement enclosingType = XElements.closestEnclosingTypeElement(method);
            for (XMethodElement subclassMethod : this.subclassMethodMap.get((Object)XElements.getSimpleName(method))) {
                if (method == subclassMethod || !XProcessingEnvs.javacOverrides(subclassMethod, method, enclosingType)) continue;
                return Optional.empty();
            }
            XMethodType resolved = method.asMemberOf(container);
            return Optional.of(MembersInjectionBinding.InjectionSite.method(method, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), resolved.getParameterTypes())));
        }

        public Optional<MembersInjectionBinding.InjectionSite> visitField(XFieldElement field, XType container) {
            if (!this.shouldBeInjected(field)) {
                return Optional.empty();
            }
            XType resolved = field.asMemberOf(container);
            return Optional.of(MembersInjectionBinding.InjectionSite.field(field, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariable(field, resolved)));
        }

        private boolean shouldBeInjected(XElement injectionSite) {
            return InjectionAnnotations.hasInjectAnnotation(injectionSite) && !XElements.isPrivate(injectionSite) && !XElements.isStatic(injectionSite);
        }
    }
}

