/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata;
import dagger.internal.codegen.binding.AutoValue_AssistedInjectionAnnotations_AssistedParameter;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XConstructorType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XVariableElement;
import java.util.List;
import java.util.Optional;

public final class AssistedInjectionAnnotations {
    public static XMethodElement assistedFactoryMethod(XTypeElement factory) {
        ImmutableSet<XMethodElement> factoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory);
        if (factoryMethods.size() != 1) {
            throw new IllegalStateException("Expected exactly one factory method for " + XElements.toStableString(factory) + " but found: " + factoryMethods.stream().map(method -> XElements.toStableString(method.getEnclosingElement()) + "#" + XElements.toStableString(method)).collect(DaggerStreams.toImmutableList()));
        }
        return (XMethodElement)Iterables.getOnlyElement(factoryMethods);
    }

    public static ImmutableSet<XMethodElement> assistedFactoryMethods(XTypeElement factory) {
        return (ImmutableSet)XTypeElements.getAllNonPrivateInstanceMethods(factory).stream().filter(XHasModifiers::isAbstract).filter(method -> !method.isJavaDefault()).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean isAssistedInjectionType(XTypeElement typeElement) {
        return AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement).stream().anyMatch(constructor -> constructor.hasAnnotation(XTypeNames.ASSISTED_INJECT));
    }

    public static boolean isAssistedFactoryType(XElement element) {
        return element.hasAnnotation(XTypeNames.ASSISTED_FACTORY);
    }

    public static ImmutableList<XParameterSpec> assistedParameterSpecs(Binding binding) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        XConstructorElement constructor = XElements.asConstructor(binding.bindingElement().get());
        XConstructorType constructorType = constructor.asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionAnnotations.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes());
    }

    private static ImmutableList<XParameterSpec> assistedParameterSpecs(List<? extends XExecutableParameterElement> paramElements, List<XType> paramTypes) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            XExecutableParameterElement paramElement = paramElements.get(i);
            XType paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)XParameterSpecs.of(paramElement.getJvmName(), paramType.asTypeName()));
        }
        return assistedParameterSpecs.build();
    }

    public static ImmutableList<XParameterSpec> assistedFactoryParameterSpecs(Binding binding) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_FACTORY ? 1 : 0) != 0);
        XTypeElement factory = XElements.asTypeElement(binding.bindingElement().get());
        AssistedFactoryMetadata metadata = AssistedFactoryMetadata.create(factory.getType());
        XMethodType factoryMethodType = metadata.factoryMethod().asMemberOf(binding.key().type().xprocessing());
        return AssistedInjectionAnnotations.assistedParameterSpecs((List)metadata.assistedFactoryAssistedParameters().stream().map(arg_0 -> metadata.assistedInjectAssistedParametersMap().get(arg_0)).collect(DaggerStreams.toImmutableList()), factoryMethodType.getParameterTypes());
    }

    public static ImmutableSet<XConstructorElement> assistedInjectedConstructors(XTypeElement type) {
        return (ImmutableSet)type.getConstructors().stream().filter(constructor -> constructor.hasAnnotation(XTypeNames.ASSISTED_INJECT)).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableList<XExecutableParameterElement> assistedParameters(Binding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? (ImmutableList)XElements.asConstructor(binding.bindingElement().get()).getParameters().stream().filter(AssistedInjectionAnnotations::isAssistedParameter).collect(DaggerStreams.toImmutableList()) : ImmutableList.of();
    }

    public static boolean isAssistedParameter(XVariableElement param) {
        return param.hasAnnotation(XTypeNames.ASSISTED);
    }

    public static ImmutableList<AssistedParameter> assistedInjectAssistedParameters(XType assistedInjectType) {
        XConstructorElement assistedInjectConstructor = (XConstructorElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(assistedInjectType.getTypeElement()));
        XConstructorType assistedInjectConstructorType = assistedInjectConstructor.asMemberOf(assistedInjectType.makeNonNullable());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < assistedInjectConstructor.getParameters().size(); ++i) {
            XExecutableParameterElement parameter = assistedInjectConstructor.getParameters().get(i);
            XType parameterType = assistedInjectConstructorType.getParameterTypes().get(i);
            if (!parameter.hasAnnotation(XTypeNames.ASSISTED)) continue;
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    private static ImmutableList<AssistedParameter> assistedFactoryAssistedParameters(XMethodElement factoryMethod, XMethodType factoryMethodType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < factoryMethod.getParameters().size(); ++i) {
            XExecutableParameterElement parameter = factoryMethod.getParameters().get(i);
            XType parameterType = factoryMethodType.getParameterTypes().get(i);
            builder.add((Object)AssistedParameter.create(parameter, parameterType));
        }
        return builder.build();
    }

    private AssistedInjectionAnnotations() {
    }

    @AutoValue
    public static abstract class AssistedFactoryMetadata {
        public static AssistedFactoryMetadata create(XType factoryType) {
            XTypeElement factoryElement = factoryType.getTypeElement();
            XMethodElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factoryElement);
            XMethodType factoryMethodType = factoryMethod.asMemberOf(factoryType);
            XType assistedInjectType = factoryMethodType.getReturnType();
            XTypeElement assistedInjectElement = assistedInjectType.getTypeElement();
            return new AutoValue_AssistedInjectionAnnotations_AssistedFactoryMetadata(factoryElement, factoryType, factoryMethod, factoryMethodType, assistedInjectElement, assistedInjectType, AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType), (ImmutableList<AssistedParameter>)AssistedInjectionAnnotations.assistedFactoryAssistedParameters(factoryMethod, factoryMethodType));
        }

        public abstract XTypeElement factory();

        public abstract XType factoryType();

        public abstract XMethodElement factoryMethod();

        public abstract XMethodType factoryMethodType();

        public abstract XTypeElement assistedInjectElement();

        public abstract XType assistedInjectType();

        public abstract ImmutableList<AssistedParameter> assistedInjectAssistedParameters();

        public abstract ImmutableList<AssistedParameter> assistedFactoryAssistedParameters();

        @Memoized
        public ImmutableMap<AssistedParameter, XExecutableParameterElement> assistedInjectAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedInjectAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.element());
            }
            return builder.build();
        }

        @Memoized
        public ImmutableMap<AssistedParameter, XExecutableParameterElement> assistedFactoryAssistedParametersMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AssistedParameter assistedParameter : this.assistedFactoryAssistedParameters()) {
                builder.put((Object)assistedParameter, (Object)assistedParameter.element());
            }
            return builder.build();
        }
    }

    @AutoValue
    public static abstract class AssistedParameter {
        private XExecutableParameterElement parameterElement;

        public static AssistedParameter create(XExecutableParameterElement parameter, XType parameterType) {
            AutoValue_AssistedInjectionAnnotations_AssistedParameter assistedParameter = new AutoValue_AssistedInjectionAnnotations_AssistedParameter(Optional.ofNullable(parameter.getAnnotation(XTypeNames.ASSISTED)).map(assisted -> assisted.getAsString("value")).orElse(""), (Equivalence.Wrapper<XType>)XTypes.equivalence().wrap((Object)parameterType));
            assistedParameter.parameterElement = parameter;
            return assistedParameter;
        }

        public abstract String qualifier();

        abstract Equivalence.Wrapper<XType> wrappedType();

        public final XType type() {
            return (XType)this.wrappedType().get();
        }

        public final XExecutableParameterElement element() {
            return this.parameterElement;
        }

        public final String toString() {
            return this.qualifier().isEmpty() ? String.format("@Assisted %s", XTypes.toStableString(this.type())) : String.format("@Assisted(\"%s\") %s", this.qualifier(), XTypes.toStableString(this.type()));
        }
    }
}

