/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.AutoValue_ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class ComponentAnnotation {
    private static final ImmutableSet<XClassName> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of((Object)XTypeNames.COMPONENT, (Object)XTypeNames.PRODUCTION_COMPONENT);
    private static final ImmutableSet<XClassName> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of((Object)XTypeNames.SUBCOMPONENT, (Object)XTypeNames.PRODUCTION_SUBCOMPONENT);
    private static final ImmutableSet<XClassName> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();
    private static final ImmutableSet<XClassName> ALL_COMPONENT_AND_CREATOR_ANNOTATIONS = ImmutableSet.builder().addAll(ALL_COMPONENT_ANNOTATIONS).addAll(ComponentCreatorAnnotation.allCreatorAnnotations()).build();
    private static final ImmutableSet<XClassName> PRODUCTION_ANNOTATIONS = ImmutableSet.of((Object)XTypeNames.PRODUCTION_COMPONENT, (Object)XTypeNames.PRODUCTION_SUBCOMPONENT, (Object)XTypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract XClassName className();

    public final String simpleName() {
        return this.className().getSimpleName();
    }

    public final boolean isSubcomponent() {
        return SUBCOMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isProduction() {
        return PRODUCTION_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isRealComponent() {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    @Memoized
    public ImmutableList<XType> dependencyTypes() {
        return this.isRootComponent() ? ImmutableList.copyOf(this.annotation.getAsTypeList("dependencies")) : ImmutableList.of();
    }

    @Memoized
    public ImmutableSet<XTypeElement> dependencies() {
        return (ImmutableSet)this.dependencyTypes().stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    @Memoized
    public ImmutableSet<XTypeElement> modules() {
        return (ImmutableSet)this.annotation.getAsTypeList(this.isRealComponent() ? "modules" : "includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    private final boolean isRootComponent() {
        return ROOT_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public static Optional<ComponentAnnotation> rootComponentAnnotation(XTypeElement typeElement, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement, ROOT_COMPONENT_ANNOTATIONS, superficialValidation);
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(XTypeElement typeElement, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement, SUBCOMPONENT_ANNOTATIONS, superficialValidation);
    }

    public static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, DaggerSuperficialValidation superficialValidation) {
        return ComponentAnnotation.anyComponentAnnotation(element, ALL_COMPONENT_ANNOTATIONS, superficialValidation);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, Collection<XClassName> annotations, DaggerSuperficialValidation superficialValidation) {
        return XElements.getAnyAnnotation((XAnnotated)element, annotations).map(annotation -> {
            superficialValidation.validateAnnotationOf(element, (XAnnotation)annotation);
            return ComponentAnnotation.create(annotation);
        });
    }

    public static boolean isComponentAnnotation(XAnnotation annotation) {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)XAnnotations.asClassName(annotation));
    }

    public static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return ComponentAnnotation.create(moduleAnnotation.annotation());
    }

    private static ComponentAnnotation create(XAnnotation annotation) {
        AutoValue_ComponentAnnotation componentAnnotation = new AutoValue_ComponentAnnotation(XAnnotations.asClassName(annotation));
        componentAnnotation.annotation = annotation;
        return componentAnnotation;
    }

    public static ImmutableSet<XClassName> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<XClassName> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<XClassName> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<XClassName> allComponentAndCreatorAnnotations() {
        return ALL_COMPONENT_AND_CREATOR_ANNOTATIONS;
    }
}

