/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.Keys;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import javax.inject.Inject;

final class BindsOptionalOfMethodValidator
extends BindingMethodValidator {
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    BindsOptionalOfMethodValidator(XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(XTypeNames.BINDS_OPTIONAL_OF, (Iterable<XClassName>)ImmutableSet.of((Object)XTypeNames.MODULE, (Object)XTypeNames.PRODUCER_MODULE), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, processingEnv, dependencyRequestValidator, injectionAnnotations);
        this.injectionAnnotations = injectionAnnotations;
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(method);
            this.method = method;
        }

        @Override
        protected void checkKeyType(XType keyType) {
            super.checkKeyType(keyType);
            if (Keys.isValidImplicitProvisionKey(BindsOptionalOfMethodValidator.this.injectionAnnotations.getQualifiers(this.method).stream().findFirst(), keyType) && !InjectionAnnotations.injectedConstructors(keyType.getTypeElement()).isEmpty()) {
                this.report.addError("@BindsOptionalOf methods cannot return unqualified types that have an @Inject-annotated constructor because those are always present");
            }
        }

        @Override
        protected void checkParameters() {
            if (!this.method.getParameters().isEmpty()) {
                this.report.addError("@BindsOptionalOf methods cannot have parameters");
            }
        }
    }
}

