/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.binding.MonitoringModules;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.processingstep.ComponentProcessingStep;
import dagger.internal.codegen.processingstep.SuperficialValidator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.tools.Diagnostic;

abstract class TypeCheckingProcessingStep<E extends XElement>
implements XProcessingStep {
    private final List<String> lastDeferredErrorMessages = new ArrayList<String>();
    @Inject
    XMessager messager;
    @Inject
    CompilerOptions compilerOptions;
    @Inject
    SuperficialValidator superficialValidator;
    @Inject
    MonitoringModules monitoringModules;

    TypeCheckingProcessingStep() {
    }

    public final ImmutableSet<String> annotations() {
        return (ImmutableSet)this.annotationClassNames().stream().map(XClassName::getCanonicalName).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<XElement> process(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        this.lastDeferredErrorMessages.clear();
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        this.inverse(elementsByAnnotation).forEach((element, annotations) -> {
            try {
                if (this instanceof ComponentProcessingStep && !this.monitoringModules.isEmpty()) {
                    deferredElements.add(element);
                    return;
                }
                if (this.requiresPreValidation()) {
                    this.superficialValidator.throwIfNearestEnclosingTypeNotValid((XElement)element);
                }
                this.process(element, (ImmutableSet<XClassName>)annotations);
            }
            catch (TypeNotPresentException e) {
                deferredElements.add(element);
                this.cacheErrorMessage(this.typeNotPresentErrorMessage((XElement)element, e), e);
            }
            catch (DaggerSuperficialValidation.ValidationException.UnexpectedException unexpectedException) {
                throw unexpectedException;
            }
            catch (DaggerSuperficialValidation.ValidationException.KnownErrorType e) {
                deferredElements.add(element);
                this.cacheErrorMessage(this.knownErrorTypeErrorMessage((XElement)element, e), e);
            }
            catch (DaggerSuperficialValidation.ValidationException.UnknownErrorType e) {
                deferredElements.add(element);
                this.cacheErrorMessage(this.unknownErrorTypeErrorMessage((XElement)element, e), e);
            }
        });
        return deferredElements.build();
    }

    protected boolean requiresPreValidation() {
        return true;
    }

    public void processOver(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        this.lastDeferredErrorMessages.forEach(errorMessage -> this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessage));
        this.lastDeferredErrorMessages.clear();
    }

    private void cacheErrorMessage(String errorMessage, Exception exception) {
        this.lastDeferredErrorMessages.add(this.compilerOptions.includeStacktraceWithDeferredErrorMessages() ? String.format("%s\n\n%s", errorMessage, Throwables.getStackTraceAsString((Throwable)exception)) : errorMessage);
    }

    private String typeNotPresentErrorMessage(XElement element, TypeNotPresentException exception) {
        return String.format("%1$s was unable to process '%2$s' because '%3$s' could not be resolved.\n\nIf type '%3$s' is a generated type, check above for compilation errors that may have prevented the type from being generated. Otherwise, ensure that type '%3$s' is on your classpath.", this.getClass().getSimpleName(), XElements.toStableString(element), exception.typeName());
    }

    private String knownErrorTypeErrorMessage(XElement element, DaggerSuperficialValidation.ValidationException.KnownErrorType exception) {
        return String.format("%1$s was unable to process '%2$s' because '%3$s' could not be resolved.\n\nDependency trace:\n    => %4$s\n\nIf type '%3$s' is a generated type, check above for compilation errors that may have prevented the type from being generated. Otherwise, ensure that type '%3$s' is on your classpath.", this.getClass().getSimpleName(), XElements.toStableString(element), exception.getErrorTypeName(), exception.getTrace());
    }

    private String unknownErrorTypeErrorMessage(XElement element, DaggerSuperficialValidation.ValidationException.UnknownErrorType exception) {
        return String.format("%1$s was unable to process '%2$s' because one of its dependencies could not be resolved.\n\nDependency trace:\n    => %3$s\n\nIf the dependency is a generated type, check above for compilation errors that may have prevented the type from being generated. Otherwise, ensure that the dependency is on your classpath.", this.getClass().getSimpleName(), XElements.toStableString(element), exception.getTrace());
    }

    protected abstract void process(E var1, ImmutableSet<XClassName> var2);

    private ImmutableMap<XElement, ImmutableSet<XClassName>> inverse(Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        ImmutableMap annotationClassNames = (ImmutableMap)this.annotationClassNames().stream().collect(DaggerStreams.toImmutableMap(XClassName::getCanonicalName, className -> className));
        Preconditions.checkState((boolean)annotationClassNames.keySet().containsAll(elementsByAnnotation.keySet()), (String)"Unexpected annotations for %s: %s", (Object)this.getClass().getCanonicalName(), (Object)Sets.difference(elementsByAnnotation.keySet(), (Set)annotationClassNames.keySet()));
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        elementsByAnnotation.forEach((annotationName, elementSet) -> elementSet.forEach(element -> builder.put(element, (Object)((XClassName)annotationClassNames.get(annotationName)))));
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)builder.build().asMap(), ImmutableSet::copyOf));
    }

    protected abstract Set<XClassName> annotationClassNames();
}

