/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.Preconditions;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class FactoryGenerator
extends SourceFileGenerator<ContributionBinding> {
    private static final ImmutableSet<BindingKind> VALID_BINDING_KINDS = ImmutableSet.of((Object)((Object)BindingKind.INJECTION), (Object)((Object)BindingKind.ASSISTED_INJECTION), (Object)((Object)BindingKind.PROVISION));
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    FactoryGenerator(XFiler filer, CompilerOptions compilerOptions, SourceFiles sourceFiles, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ContributionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(ContributionBinding binding) {
        com.google.common.base.Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        com.google.common.base.Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        com.google.common.base.Preconditions.checkArgument((boolean)VALID_BINDING_KINDS.contains((Object)binding.kind()));
        return ImmutableList.of((Object)this.factoryBuilder(binding));
    }

    private TypeSpec.Builder factoryBuilder(ContributionBinding binding) {
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder((ClassName)SourceFiles.generatedClassNameForBinding(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding)).addAnnotation(this.scopeMetadataAnnotation(binding)).addAnnotation(this.qualifierMetadataAnnotation(binding));
        FactoryGenerator.factoryTypeName(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addSuperinterface(arg_0));
        FactoryFields factoryFields = FactoryFields.create(binding);
        if (factoryFields.isEmpty()) {
            factoryBuilder.addType(this.staticInstanceHolderType(binding));
        } else {
            factoryBuilder.addFields(factoryFields.getAll()).addMethod(this.constructorMethod(factoryFields));
        }
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(arg_0 -> ((TypeSpec.Builder)factoryBuilder).addAnnotation(arg_0));
        return factoryBuilder.addMethod(this.getMethod(binding, factoryFields)).addMethods(this.staticCreateMethod(binding, factoryFields)).addMethod(this.staticProxyMethod(binding));
    }

    private TypeSpec staticInstanceHolderType(ContributionBinding binding) {
        ClassName generatedClassName = SourceFiles.generatedClassNameForBinding(binding);
        FieldSpec.Builder instanceHolderFieldBuilder = FieldSpec.builder((TypeName)generatedClassName, (String)"INSTANCE", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{generatedClassName});
        if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
            instanceHolderFieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        return TypeSpec.classBuilder((ClassName)FactoryGenerator.instanceHolderClassName(binding)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addField(instanceHolderFieldBuilder.build()).build();
    }

    private static ClassName instanceHolderClassName(ContributionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding).nestedClass("InstanceHolder");
    }

    private MethodSpec constructorMethod(FactoryFields factoryFields) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        factoryFields.getAll().forEach(field -> constructor.addParameter(field.type, field.name, new Modifier[0]).addStatement("this.$1N = $1N", new Object[]{field}));
        return constructor.build();
    }

    private ImmutableList<MethodSpec> staticCreateMethod(ContributionBinding binding, FactoryFields factoryFields) {
        ImmutableList.Builder methodsBuilder = ImmutableList.builder();
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding));
        if (factoryFields.isEmpty()) {
            if (!SourceFiles.bindingTypeElementTypeVariableNames(binding).isEmpty()) {
                createMethodBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
            }
            createMethodBuilder.addStatement("return $T.INSTANCE", new Object[]{FactoryGenerator.instanceHolderClassName(binding)});
        } else {
            ImmutableList parameters = (ImmutableList)factoryFields.getAll().stream().map(field -> ParameterSpec.builder((TypeName)field.type, (String)field.name, (Modifier[])new Modifier[0]).build()).collect(DaggerStreams.toImmutableList());
            createMethodBuilder.addParameters((Iterable)parameters).addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), CodeBlocks.parameterNames((Iterable<ParameterSpec>)parameters)});
            if (FactoryGenerator.hasDaggerProviderParams((List<ParameterSpec>)parameters)) {
                methodsBuilder.add((Object)this.javaxCreateMethod(binding, (ImmutableList<ParameterSpec>)parameters));
            }
        }
        methodsBuilder.add((Object)createMethodBuilder.build());
        return methodsBuilder.build();
    }

    private MethodSpec javaxCreateMethod(ContributionBinding binding, ImmutableList<ParameterSpec> parameters) {
        ImmutableList<ParameterSpec> remappedParams = FactoryGenerator.remapParamsToJavaxProvider(parameters);
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariables(SourceFiles.bindingTypeElementTypeVariableNames(binding)).addParameters(remappedParams).addStatement("return new $T($L)", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), FactoryGenerator.wrappedParametersCodeBlock(remappedParams)}).build();
    }

    private MethodSpec getMethod(ContributionBinding binding, FactoryFields factoryFields) {
        UniqueNameSet uniqueFieldNames = new UniqueNameSet();
        factoryFields.getAll().forEach(field -> uniqueFieldNames.claim(field.name));
        ImmutableMap assistedParameters = (ImmutableMap)AssistedInjectionAnnotations.assistedParameters(binding).stream().collect(DaggerStreams.toImmutableMap(parameter -> parameter, parameter -> ParameterSpec.builder((TypeName)parameter.getType().getTypeName(), (String)uniqueFieldNames.getUniqueName(parameter.getJvmName()), (Modifier[])new Modifier[0]).build()));
        TypeName providedTypeName = FactoryGenerator.providedTypeName(binding);
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameters((Iterable)assistedParameters.values());
        if (FactoryGenerator.factoryTypeName(binding).isPresent()) {
            getMethod.addAnnotation(Override.class);
        }
        CodeBlock invokeNewInstance = InjectionMethods.ProvisionMethod.invoke(binding, request -> this.sourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{factoryFields.get((DependencyRequest)request)}), request.kind()), param -> ((ParameterSpec)assistedParameters.get((Object)param)).name, SourceFiles.generatedClassNameForBinding(binding), factoryFields.moduleField.map(module -> CodeBlock.of((String)"$N", (Object[])new Object[]{module})), this.compilerOptions);
        if (binding.kind().equals((Object)BindingKind.PROVISION)) {
            binding.nullability().nonTypeUseNullableAnnotations().forEach(arg_0 -> ((MethodSpec.Builder)getMethod).addAnnotation(arg_0));
            getMethod.addStatement("return $L", new Object[]{invokeNewInstance}).returns(providedTypeName);
        } else if (!this.injectionSites(binding).isEmpty()) {
            CodeBlock instance = CodeBlock.of((String)"instance", (Object[])new Object[0]);
            getMethod.returns(providedTypeName).addStatement("$T $L = $L", new Object[]{providedTypeName, instance, invokeNewInstance}).addCode(InjectionMethods.InjectionSiteMethod.invokeAll(this.injectionSites(binding), SourceFiles.generatedClassNameForBinding(binding), instance, binding.key().type().xprocessing(), arg_0 -> this.sourceFiles.frameworkFieldUsages(binding.dependencies(), (ImmutableMap<DependencyRequest, FieldSpec>)factoryFields.frameworkFields).get(arg_0))).addStatement("return $L", new Object[]{instance});
        } else {
            getMethod.returns(providedTypeName).addStatement("return $L", new Object[]{invokeNewInstance});
        }
        return getMethod.build();
    }

    private MethodSpec staticProxyMethod(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: 
            case ASSISTED_INJECTION: {
                return FactoryGenerator.staticProxyMethodForInjection(binding);
            }
            case PROVISION: {
                return this.staticProxyMethodForProvision((ProvisionBinding)binding);
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + binding));
    }

    private static MethodSpec staticProxyMethodForInjection(ContributionBinding binding) {
        XConstructorElement constructor = XElements.asConstructor(binding.bindingElement().get());
        XTypeElement enclosingType = constructor.getEnclosingElement();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)SourceFiles.generatedProxyMethodName(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(constructor.isVarArgs()).returns(enclosingType.getType().getTypeName()).addTypeVariables(XTypeElements.typeVariableNames(enclosingType)).addExceptions(FactoryGenerator.getThrownTypes((XExecutableElement)constructor));
        CodeBlock arguments = InjectionMethods.copyParameters(builder, new UniqueNameSet(), constructor.getParameters());
        return builder.addStatement("return new $T($L)", new Object[]{enclosingType.getType().getTypeName(), arguments}).build();
    }

    private MethodSpec staticProxyMethodForProvision(ProvisionBinding binding) {
        CodeBlock module;
        XMethodElement method = XElements.asMethod(binding.bindingElement().get());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)SourceFiles.generatedProxyMethodName(binding)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).varargs(method.isVarArgs()).addExceptions(FactoryGenerator.getThrownTypes((XExecutableElement)method));
        XTypeElement enclosingType = XElements.asTypeElement((XElement)method.getEnclosingElement());
        UniqueNameSet parameterNameSet = new UniqueNameSet();
        if (method.isStatic() || enclosingType.isCompanionObject()) {
            module = CodeBlock.of((String)"$T", (Object[])new Object[]{enclosingType.getClassName()});
        } else if (enclosingType.isKotlinObject()) {
            module = CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{enclosingType.getClassName()});
        } else {
            builder.addTypeVariables(XTypeElements.typeVariableNames(enclosingType));
            module = FactoryGenerator.copyInstance(builder, parameterNameSet, enclosingType.getType());
        }
        CodeBlock arguments = InjectionMethods.copyParameters(builder, parameterNameSet, method.getParameters());
        CodeBlock invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, method.getJvmName(), arguments});
        Nullability nullability = Nullability.of((XElement)method);
        nullability.nonTypeUseNullableAnnotations().forEach(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        return builder.returns(method.getReturnType().getTypeName().annotated((List)nullability.typeUseNullableAnnotations().stream().map(annotation -> AnnotationSpec.builder((ClassName)annotation).build()).collect(DaggerStreams.toImmutableList()))).addStatement("return $L", new Object[]{this.maybeWrapInCheckForNull(binding, invocation)}).build();
    }

    private CodeBlock maybeWrapInCheckForNull(ProvisionBinding binding, CodeBlock codeBlock) {
        return binding.shouldCheckForNull(this.compilerOptions) ? CodeBlock.of((String)"$T.checkNotNullFromProvides($L)", (Object[])new Object[]{Preconditions.class, codeBlock}) : codeBlock;
    }

    private static CodeBlock copyInstance(MethodSpec.Builder methodBuilder, UniqueNameSet parameterNameSet, XType type) {
        return InjectionMethods.copyParameter(methodBuilder, type, parameterNameSet.getUniqueName("instance"), false, Nullability.NOT_NULLABLE);
    }

    private static ImmutableList<TypeName> getThrownTypes(XExecutableElement executable) {
        return (ImmutableList)executable.getThrownTypes().stream().map(XType::getTypeName).collect(DaggerStreams.toImmutableList());
    }

    private AnnotationSpec scopeMetadataAnnotation(ContributionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)TypeNames.SCOPE_METADATA);
        binding.scope().map(Scope::scopeAnnotation).map(DaggerAnnotation::className).map(ClassName::canonicalName).ifPresent(scopeCanonicalName -> builder.addMember("value", "$S", new Object[]{scopeCanonicalName}));
        return builder.build();
    }

    private AnnotationSpec qualifierMetadataAnnotation(ContributionBinding binding) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)TypeNames.QUALIFIER_METADATA);
        Stream.concat(Stream.of(binding.key()), this.provisionDependencies(binding).stream().map(DependencyRequest::key)).map(Key::qualifier).flatMap(DaggerStreams.presentValues()).map(DaggerAnnotation::className).map(ClassName::canonicalName).distinct().forEach(qualifier -> builder.addMember("value", "$S", new Object[]{qualifier}));
        return builder.build();
    }

    private ImmutableSet<DependencyRequest> provisionDependencies(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).constructorDependencies();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).constructorDependencies();
            }
            case PROVISION: {
                return ((ProvisionBinding)binding).dependencies();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private ImmutableSet<MembersInjectionBinding.InjectionSite> injectionSites(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return ((InjectionBinding)binding).injectionSites();
            }
            case ASSISTED_INJECTION: {
                return ((AssistedInjectionBinding)binding).injectionSites();
            }
            case PROVISION: {
                return ImmutableSet.of();
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    private static TypeName providedTypeName(ContributionBinding binding) {
        return binding.contributedType().getTypeName().annotated((List)binding.nullability().typeUseNullableAnnotations().stream().map(annotation -> AnnotationSpec.builder((ClassName)annotation).build()).collect(DaggerStreams.toImmutableList()));
    }

    private static Optional<TypeName> factoryTypeName(ContributionBinding binding) {
        return binding.kind() == BindingKind.ASSISTED_INJECTION ? Optional.empty() : Optional.of(TypeNames.factoryOf(FactoryGenerator.providedTypeName(binding)));
    }

    static boolean hasDaggerProviderParams(List<ParameterSpec> params) {
        return params.stream().anyMatch(param -> FactoryGenerator.isDaggerProviderType(param.type));
    }

    static CodeBlock wrappedParametersCodeBlock(List<ParameterSpec> params) {
        return CodeBlocks.makeParametersCodeBlock(Lists.transform(params, input -> FactoryGenerator.isProviderType(input.type) ? CodeBlock.of((String)"$T.asDaggerProvider($N)", (Object[])new Object[]{TypeNames.DAGGER_PROVIDERS, input}) : CodeBlock.of((String)"$N", (Object[])new Object[]{input})));
    }

    static ImmutableList<ParameterSpec> remapParamsToJavaxProvider(List<ParameterSpec> params) {
        return (ImmutableList)params.stream().map(param -> ParameterSpec.builder((TypeName)FactoryGenerator.remapDaggerProviderToProvider(param.type), (String)param.name, (Modifier[])new Modifier[0]).build()).collect(DaggerStreams.toImmutableList());
    }

    private static boolean isDaggerProviderType(TypeName type) {
        return type instanceof ParameterizedTypeName && ((ParameterizedTypeName)type).rawType.equals((Object)TypeNames.DAGGER_PROVIDER);
    }

    private static boolean isProviderType(TypeName type) {
        return type instanceof ParameterizedTypeName && ((ParameterizedTypeName)type).rawType.equals((Object)TypeNames.PROVIDER);
    }

    private static TypeName remapDaggerProviderToProvider(TypeName type) {
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)type;
            if (parameterizedTypeName.rawType.equals((Object)TypeNames.DAGGER_PROVIDER)) {
                return ParameterizedTypeName.get((ClassName)TypeNames.PROVIDER, (TypeName[])parameterizedTypeName.typeArguments.toArray(new TypeName[0]));
            }
        }
        return type;
    }

    private static final class FactoryFields {
        private final Optional<FieldSpec> moduleField;
        private final ImmutableMap<DependencyRequest, FieldSpec> frameworkFields;

        static FactoryFields create(ContributionBinding binding) {
            UniqueNameSet nameSet = new UniqueNameSet();
            Optional<FieldSpec> moduleField = binding.requiresModuleInstance() ? Optional.of(FactoryFields.createField(binding.bindingTypeElement().get().getType().getTypeName(), nameSet.getUniqueName("module"))) : Optional.empty();
            ImmutableMap.Builder frameworkFields = ImmutableMap.builder();
            SourceFiles.generateBindingFieldsForDependencies(binding).forEach((dependency, field) -> frameworkFields.put(dependency, (Object)FactoryFields.createField(XTypeNameKt.toJavaPoet((XTypeName)field.type()), nameSet.getUniqueName(field.name()))));
            return new FactoryFields(moduleField, (ImmutableMap<DependencyRequest, FieldSpec>)frameworkFields.buildOrThrow());
        }

        private static FieldSpec createField(TypeName type, String name) {
            return FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        }

        private FactoryFields(Optional<FieldSpec> moduleField, ImmutableMap<DependencyRequest, FieldSpec> frameworkFields) {
            this.moduleField = moduleField;
            this.frameworkFields = frameworkFields;
        }

        FieldSpec get(DependencyRequest request) {
            return (FieldSpec)this.frameworkFields.get((Object)request);
        }

        ImmutableList<FieldSpec> getAll() {
            return this.moduleField.isPresent() ? ImmutableList.builder().add((Object)this.moduleField.get()).addAll((Iterable)this.frameworkFields.values()).build() : this.frameworkFields.values().asList();
        }

        boolean isEmpty() {
            return this.getAll().isEmpty();
        }
    }
}

