/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.writing.LazyMapKeyProxyGenerator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

final class LazyClassKeyProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private static final String PROGUARD_KEEP_RULE = "-keep,allowobfuscation,allowshrinking class ";
    private final SetMultimap<ClassName, ClassName> processedElements = LinkedHashMultimap.create();
    private final LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator;

    @Inject
    LazyClassKeyProcessingStep(LazyMapKeyProxyGenerator lazyMapKeyProxyGenerator) {
        this.lazyMapKeyProxyGenerator = lazyMapKeyProxyGenerator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.LAZY_CLASS_KEY);
    }

    @Override
    protected void process(XElement element, ImmutableSet<ClassName> annotations) {
        ClassName lazyClassKey = element.getAnnotation(TypeNames.LAZY_CLASS_KEY).getAsType("value").getTypeElement().getClassName();
        if (!LazyClassKeyProcessingStep.isMapBinding(element) || !LazyClassKeyProcessingStep.isModuleOrProducerModule(element.getEnclosingElement())) {
            return;
        }
        XTypeElement moduleElement = XElements.asTypeElement(element.getEnclosingElement());
        this.processedElements.put((Object)moduleElement.getClassName(), (Object)lazyClassKey);
        XMethodElement method = XElements.asMethod(element);
        this.lazyMapKeyProxyGenerator.generate(method);
    }

    private static boolean isMapBinding(XElement element) {
        return element.hasAnnotation(TypeNames.INTO_MAP) && (element.hasAnnotation(TypeNames.BINDS) || element.hasAnnotation(TypeNames.PROVIDES) || element.hasAnnotation(TypeNames.PRODUCES));
    }

    private static boolean isModuleOrProducerModule(XElement element) {
        return XElementKt.isTypeElement((XElement)element) && (element.hasAnnotation(TypeNames.MODULE) || element.hasAnnotation(TypeNames.PRODUCER_MODULE));
    }

    @Override
    public void processOver(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation) {
        super.processOver(env, elementsByAnnotation);
        StringBuilder proguardRules = new StringBuilder();
        for (Map.Entry moduleToLazyClassKeys : this.processedElements.asMap().entrySet()) {
            String bindingGraphProguardName = LazyClassKeyProcessingStep.getFullyQualifiedEnclosedClassName((ClassName)moduleToLazyClassKeys.getKey()) + "_LazyClassKeys.pro";
            for (ClassName lazyClassKey : (Collection)moduleToLazyClassKeys.getValue()) {
                proguardRules.append(PROGUARD_KEEP_RULE).append(lazyClassKey).append("\n");
            }
            this.writeProguardFile(bindingGraphProguardName, proguardRules.toString(), env.getFiler());
        }
    }

    private void writeProguardFile(String proguardFileName, String proguardRules, XFiler filer) {
        try (OutputStream outputStream = filer.writeResource(Path.of("META-INF/proguard/" + proguardFileName, new String[0]), (List)ImmutableList.of(), XFiler.Mode.Isolating);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(proguardRules);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getFullyQualifiedEnclosedClassName(ClassName className) {
        return className.packageName().replace('.', '_') + LazyClassKeyProcessingStep.getEnclosedName(className);
    }

    public static String getEnclosedName(ClassName name) {
        return Joiner.on((char)'_').join((Iterable)name.simpleNames());
    }
}

