/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.Key;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;
import javax.inject.Inject;

final class ComponentDeclarations {
    private final ImmutableSetMultimap<Key, ContributionBinding> bindings;
    private final ImmutableSetMultimap<Key, DelegateDeclaration> delegates;
    private final ImmutableSetMultimap<Key, MultibindingDeclaration> multibindings;
    private final ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindings;
    private final ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponents;
    private final ImmutableSetMultimap<Key, ContributionBinding> multibindingContributions;
    private final ImmutableSetMultimap<Key, DelegateDeclaration> delegateMultibindingContributions;

    private ComponentDeclarations(ImmutableSetMultimap<Key, ContributionBinding> bindings, ImmutableSetMultimap<Key, DelegateDeclaration> delegates, ImmutableSetMultimap<Key, MultibindingDeclaration> multibindings, ImmutableSetMultimap<Key, OptionalBindingDeclaration> optionalBindings, ImmutableSetMultimap<Key, SubcomponentDeclaration> subcomponents) {
        this.bindings = bindings;
        this.delegates = delegates;
        this.multibindings = multibindings;
        this.optionalBindings = optionalBindings;
        this.subcomponents = subcomponents;
        this.multibindingContributions = ComponentDeclarations.multibindingContributionsByMultibindingKey(bindings.values());
        this.delegateMultibindingContributions = ComponentDeclarations.multibindingContributionsByMultibindingKey(delegates.values());
    }

    ImmutableSet<ContributionBinding> bindings(Key key) {
        return this.bindings.get((Object)key);
    }

    ImmutableSet<DelegateDeclaration> delegates(Key key) {
        return this.delegates.get((Object)key);
    }

    ImmutableSet<DelegateDeclaration> delegateMultibindingContributions(Key key) {
        return this.delegateMultibindingContributions.get((Object)key);
    }

    ImmutableSet<MultibindingDeclaration> multibindings(Key key) {
        return this.multibindings.get((Object)key);
    }

    ImmutableSet<ContributionBinding> multibindingContributions(Key key) {
        return this.multibindingContributions.get((Object)key);
    }

    ImmutableSet<OptionalBindingDeclaration> optionalBindings(Key key) {
        return this.optionalBindings.get((Object)key);
    }

    ImmutableSet<SubcomponentDeclaration> subcomponents(Key key) {
        return this.subcomponents.get((Object)key);
    }

    ImmutableSet<BindingDeclaration> allDeclarations() {
        return ImmutableSet.builder().addAll((Iterable)this.bindings.values()).addAll((Iterable)this.delegates.values()).addAll((Iterable)this.multibindings.values()).addAll((Iterable)this.optionalBindings.values()).addAll((Iterable)this.subcomponents.values()).build();
    }

    private static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> multibindingContributionsByMultibindingKey(Iterable<T> declarations) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (BindingDeclaration declaration : declarations) {
            if (!declaration.key().multibindingContributionIdentifier().isPresent()) continue;
            builder.put((Object)declaration.key().withoutMultibindingContributionIdentifier(), (Object)declaration);
        }
        return builder.build();
    }

    static final class Factory {
        private final XProcessingEnv processingEnv;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;

        @Inject
        Factory(XProcessingEnv processingEnv, ModuleDescriptor.Factory moduleDescriptorFactory) {
            this.processingEnv = processingEnv;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
        }

        ComponentDeclarations create(Optional<ComponentDescriptor> parentDescriptor, ComponentDescriptor descriptor) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindings = ImmutableSet.builder();
            ImmutableSet.Builder optionalBindings = ImmutableSet.builder();
            ImmutableSet.Builder subcomponents = ImmutableSet.builder();
            bindings.addAll(descriptor.bindings());
            delegates.addAll(descriptor.delegateDeclarations());
            multibindings.addAll(descriptor.multibindingDeclarations());
            optionalBindings.addAll(descriptor.optionalBindingDeclarations());
            subcomponents.addAll(descriptor.subcomponentDeclarations());
            for (ModuleDescriptor module : this.implicitProductionModules(descriptor, parentDescriptor)) {
                bindings.addAll(module.bindings());
                delegates.addAll(module.delegateDeclarations());
                multibindings.addAll(module.multibindingDeclarations());
                optionalBindings.addAll(module.optionalDeclarations());
                subcomponents.addAll(module.subcomponentDeclarations());
            }
            return new ComponentDeclarations(Factory.indexDeclarationsByKey(bindings.build()), Factory.indexDeclarationsByKey(delegates.build()), Factory.indexDeclarationsByKey(multibindings.build()), Factory.indexDeclarationsByKey(optionalBindings.build()), Factory.indexDeclarationsByKey(subcomponents.build()));
        }

        private ImmutableSet<ModuleDescriptor> implicitProductionModules(ComponentDescriptor descriptor, Optional<ComponentDescriptor> parentDescriptor) {
            return Factory.shouldIncludeImplicitProductionModules(descriptor, parentDescriptor) ? ImmutableSet.of((Object)this.moduleDescriptorFactory.create(DaggerSuperficialValidation.requireTypeElement(this.processingEnv, SourceFiles.generatedMonitoringModuleName(descriptor.typeElement()))), (Object)this.moduleDescriptorFactory.create(this.processingEnv.requireTypeElement((TypeName)TypeNames.PRODUCTION_EXECTUTOR_MODULE))) : ImmutableSet.of();
        }

        private static boolean shouldIncludeImplicitProductionModules(ComponentDescriptor descriptor, Optional<ComponentDescriptor> parentDescriptor) {
            return descriptor.isProduction() && descriptor.isRealComponent() && (parentDescriptor.isEmpty() || !parentDescriptor.get().isProduction());
        }

        private static <T extends BindingDeclaration> ImmutableSetMultimap<Key, T> indexDeclarationsByKey(Iterable<T> declarations) {
            return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(declarations, BindingDeclaration::key));
        }
    }
}

