/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.inject.Inject;

public final class BindingDeclarationFormatter
extends Formatter<BindingDeclaration> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    @Inject
    BindingDeclarationFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    public boolean canFormat(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return true;
        }
        if (bindingDeclaration.bindingElement().isPresent()) {
            XElement bindingElement = bindingDeclaration.bindingElement().get();
            return XElementKt.isMethodParameter((XElement)bindingElement) || XElementKt.isTypeElement((XElement)bindingElement) || XElements.isExecutable(bindingElement);
        }
        return false;
    }

    @Override
    public String format(BindingDeclaration bindingDeclaration) {
        if (bindingDeclaration instanceof SubcomponentDeclaration) {
            return this.formatSubcomponentDeclaration((SubcomponentDeclaration)bindingDeclaration);
        }
        if (bindingDeclaration.bindingElement().isPresent()) {
            XElement bindingElement = bindingDeclaration.bindingElement().get();
            if (XElementKt.isMethodParameter((XElement)bindingElement)) {
                return ElementFormatter.elementToString(bindingElement);
            }
            if (XElementKt.isTypeElement((XElement)bindingElement)) {
                return DiagnosticFormatting.stripCommonTypePrefixes(XTypes.toStableString(XElements.asTypeElement(bindingElement).getType()));
            }
            if (XElements.isExecutable(bindingElement)) {
                return this.methodSignatureFormatter.format(XElements.asExecutable(bindingElement), bindingDeclaration.contributingModule().map(XTypeElement::getType));
            }
            throw new IllegalArgumentException("Formatting unsupported for element: " + bindingElement);
        }
        return String.format("Dagger-generated binding for %s", DiagnosticFormatting.stripCommonTypePrefixes(bindingDeclaration.key().toString()));
    }

    private String formatSubcomponentDeclaration(SubcomponentDeclaration subcomponentDeclaration) {
        ImmutableList<XTypeElement> moduleSubcomponents = subcomponentDeclaration.moduleAnnotation().subcomponents();
        int index = moduleSubcomponents.indexOf((Object)subcomponentDeclaration.subcomponentType());
        StringBuilder annotationValue = new StringBuilder();
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("{");
        }
        annotationValue.append(BindingDeclarationFormatter.formatArgumentInList(index, moduleSubcomponents.size(), subcomponentDeclaration.subcomponentType().getQualifiedName() + ".class"));
        if (moduleSubcomponents.size() != 1) {
            annotationValue.append("}");
        }
        return String.format("@%s(subcomponents = %s) for %s", subcomponentDeclaration.moduleAnnotation().simpleName(), annotationValue, subcomponentDeclaration.contributingModule().get());
    }
}

