/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import java.util.stream.Collectors;

public final class XAnnotationValues {
    private static final Equivalence<XAnnotationValue> XANNOTATION_VALUE_EQUIVALENCE = new Equivalence<XAnnotationValue>(){

        protected boolean doEquivalent(XAnnotationValue left, XAnnotationValue right) {
            if (left.hasAnnotationValue()) {
                return right.hasAnnotationValue() && XAnnotations.equivalence().equivalent((Object)left.asAnnotation(), (Object)right.asAnnotation());
            }
            if (left.hasListValue()) {
                return right.hasListValue() && XAnnotationValues.equivalence().pairwise().equivalent((Object)left.asAnnotationValueList(), (Object)right.asAnnotationValueList());
            }
            if (left.hasTypeValue()) {
                return right.hasTypeValue() && XTypes.equivalence().equivalent((Object)left.asType(), (Object)right.asType());
            }
            return left.getValue().equals(right.getValue());
        }

        protected int doHash(XAnnotationValue value) {
            if (value.hasAnnotationValue()) {
                return XAnnotations.equivalence().hash((Object)value.asAnnotation());
            }
            if (value.hasListValue()) {
                return XAnnotationValues.equivalence().pairwise().hash((Object)value.asAnnotationValueList());
            }
            if (value.hasTypeValue()) {
                return XTypes.equivalence().hash((Object)value.asType());
            }
            return value.getValue().hashCode();
        }

        public String toString() {
            return "XAnnotationValues.equivalence()";
        }
    };

    public static Equivalence<XAnnotationValue> equivalence() {
        return XANNOTATION_VALUE_EQUIVALENCE;
    }

    public static String getKindName(XAnnotationValue value) {
        if (value.hasAnnotationListValue()) {
            return "ANNOTATION_ARRAY";
        }
        if (value.hasAnnotationValue()) {
            return "ANNOTATION";
        }
        if (value.hasEnumListValue()) {
            return "ENUM_ARRAY";
        }
        if (value.hasEnumValue()) {
            return "ENUM";
        }
        if (value.hasTypeListValue()) {
            return "TYPE_ARRAY";
        }
        if (value.hasTypeValue()) {
            return "TYPE";
        }
        if (value.hasBooleanListValue()) {
            return "BOOLEAN_ARRAY";
        }
        if (value.hasBooleanValue()) {
            return "BOOLEAN";
        }
        if (value.hasByteListValue()) {
            return "BYTE_ARRAY";
        }
        if (value.hasByteValue()) {
            return "BYTE";
        }
        if (value.hasCharListValue()) {
            return "CHAR_ARRAY";
        }
        if (value.hasCharValue()) {
            return "CHAR";
        }
        if (value.hasDoubleListValue()) {
            return "DOUBLE_ARRAY";
        }
        if (value.hasDoubleValue()) {
            return "DOUBLE";
        }
        if (value.hasFloatListValue()) {
            return "FLOAT_ARRAY";
        }
        if (value.hasFloatValue()) {
            return "FLOAT";
        }
        if (value.hasIntListValue()) {
            return "INT_ARRAY";
        }
        if (value.hasIntValue()) {
            return "INT";
        }
        if (value.hasLongListValue()) {
            return "LONG_ARRAY";
        }
        if (value.hasLongValue()) {
            return "LONG";
        }
        if (value.hasShortListValue()) {
            return "SHORT_ARRAY";
        }
        if (value.hasShortValue()) {
            return "SHORT";
        }
        if (value.hasStringListValue()) {
            return "STRING_ARRAY";
        }
        if (value.hasStringValue()) {
            return "STRING";
        }
        return value.hasListValue() ? "UNKNOWN_ARRAY" : "UNKNOWN";
    }

    public static String toStableString(XAnnotationValue value) {
        try {
            if (value.getValue() == null) {
                return "<error>";
            }
            if (value.hasListValue()) {
                return value.asAnnotationValueList().stream().map(v -> XAnnotationValues.toStableString(v)).collect(Collectors.joining(", ", "{", "}"));
            }
            if (value.hasAnnotationValue()) {
                return XAnnotations.toStableString(value.asAnnotation());
            }
            if (value.hasEnumValue()) {
                return XElements.getSimpleName((XElement)value.asEnum());
            }
            if (value.hasTypeValue()) {
                return value.asType().getTypeElement().getQualifiedName();
            }
            if (value.hasStringValue()) {
                return CodeBlock.of((String)"$S", (Object[])new Object[]{value.asString()}).toString();
            }
            if (value.hasCharValue()) {
                return XAnnotationValues.characterLiteralWithSingleQuotes(value.asChar());
            }
            return value.getValue().toString();
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static String characterLiteralWithSingleQuotes(char c) {
        return "'" + XAnnotationValues.characterLiteralWithoutSingleQuotes(c) + "'";
    }

    private static String characterLiteralWithoutSingleQuotes(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Character.isISOControl(c) ? String.format("\\u%04x", c) : Character.toString(c);
    }

    private XAnnotationValues() {
    }
}

