/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

final class ComponentHierarchyValidator {
    private static final Joiner COMMA_SEPARATED_JOINER = Joiner.on((String)", ");
    private final CompilerOptions compilerOptions;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    ComponentHierarchyValidator(CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations) {
        this.compilerOptions = compilerOptions;
        this.injectionAnnotations = injectionAnnotations;
    }

    ValidationReport validate(ComponentDescriptor componentDescriptor) {
        ValidationReport.Builder report = ValidationReport.about((XElement)componentDescriptor.typeElement());
        this.validateSubcomponentMethods(report, componentDescriptor, (ImmutableMap<XTypeElement, XTypeElement>)Maps.toMap(componentDescriptor.moduleTypes(), (Function)Functions.constant((Object)componentDescriptor.typeElement())));
        this.validateRepeatedScopedDeclarations(report, componentDescriptor, (SetMultimap<ComponentDescriptor, ModuleDescriptor>)LinkedHashMultimap.create());
        if (this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
            this.validateScopeHierarchy(report, componentDescriptor, (SetMultimap<ComponentDescriptor, Scope>)LinkedHashMultimap.create());
        }
        this.validateProductionModuleUniqueness(report, componentDescriptor, (SetMultimap<ComponentDescriptor, ModuleDescriptor>)LinkedHashMultimap.create());
        return report.build();
    }

    private void validateSubcomponentMethods(ValidationReport.Builder report, ComponentDescriptor componentDescriptor, ImmutableMap<XTypeElement, XTypeElement> existingModuleToOwners) {
        componentDescriptor.childComponentsDeclaredByFactoryMethods().forEach((method, childComponent) -> {
            if (childComponent.hasCreator()) {
                report.addError("Components may not have factory methods for subcomponents that define a builder.", (XElement)method.methodElement());
            } else {
                this.validateFactoryMethodParameters(report, (ComponentDescriptor.ComponentMethodDescriptor)method, existingModuleToOwners);
            }
            this.validateSubcomponentMethods(report, (ComponentDescriptor)childComponent, (ImmutableMap<XTypeElement, XTypeElement>)new ImmutableMap.Builder().putAll((Map)existingModuleToOwners).putAll((Map)Maps.toMap((Iterable)Sets.difference(childComponent.moduleTypes(), (Set)existingModuleToOwners.keySet()), (Function)Functions.constant((Object)childComponent.typeElement()))).build());
        });
    }

    private void validateFactoryMethodParameters(ValidationReport.Builder report, ComponentDescriptor.ComponentMethodDescriptor subcomponentMethodDescriptor, ImmutableMap<XTypeElement, XTypeElement> existingModuleToOwners) {
        for (XExecutableParameterElement factoryMethodParameter : subcomponentMethodDescriptor.methodElement().getParameters()) {
            XTypeElement moduleType = factoryMethodParameter.getType().getTypeElement();
            if (!existingModuleToOwners.containsKey((Object)moduleType)) continue;
            report.addError(String.format("%s is present in %s. A subcomponent cannot use an instance of a module that differs from its parent.", XElements.getSimpleName((XMemberContainer)moduleType), ((XTypeElement)existingModuleToOwners.get((Object)moduleType)).getQualifiedName()), (XElement)factoryMethodParameter);
        }
    }

    private void validateScopeHierarchy(ValidationReport.Builder report, ComponentDescriptor subject, SetMultimap<ComponentDescriptor, Scope> scopesByComponent) {
        scopesByComponent.putAll((Object)subject, subject.scopes());
        for (ComponentDescriptor childComponent : subject.childComponents()) {
            this.validateScopeHierarchy(report, childComponent, scopesByComponent);
        }
        scopesByComponent.removeAll((Object)subject);
        Predicate subjectScopes = subject.isProduction() ? Predicates.and((Predicate)Predicates.in(subject.scopes()), (Predicate)Predicates.not(Scope::isProductionScope)) : Predicates.in(subject.scopes());
        SetMultimap overlappingScopes = Multimaps.filterValues(scopesByComponent, (Predicate)subjectScopes);
        if (!overlappingScopes.isEmpty()) {
            StringBuilder error = new StringBuilder().append(subject.typeElement().getQualifiedName()).append(" has conflicting scopes:");
            for (Map.Entry entry : overlappingScopes.entries()) {
                Scope scope = (Scope)entry.getValue();
                error.append("\n  ").append(((ComponentDescriptor)entry.getKey()).typeElement().getQualifiedName()).append(" also has ").append(Scopes.getReadableSource(scope));
            }
            report.addItem(error.toString(), this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), (XElement)subject.typeElement());
        }
    }

    private void validateProductionModuleUniqueness(ValidationReport.Builder report, ComponentDescriptor componentDescriptor, SetMultimap<ComponentDescriptor, ModuleDescriptor> producerModulesByComponent) {
        ImmutableSet producerModules = (ImmutableSet)componentDescriptor.modules().stream().filter(module -> module.kind().equals((Object)ModuleKind.PRODUCER_MODULE)).collect(DaggerStreams.toImmutableSet());
        producerModulesByComponent.putAll((Object)componentDescriptor, (Iterable)producerModules);
        for (ComponentDescriptor childComponent : componentDescriptor.childComponents()) {
            this.validateProductionModuleUniqueness(report, childComponent, producerModulesByComponent);
        }
        producerModulesByComponent.removeAll((Object)componentDescriptor);
        SetMultimap repeatedModules = Multimaps.filterValues(producerModulesByComponent, arg_0 -> ((ImmutableSet)producerModules).contains(arg_0));
        if (repeatedModules.isEmpty()) {
            return;
        }
        StringBuilder error = new StringBuilder();
        Formatter formatter = new Formatter(error);
        formatter.format("%s repeats @ProducerModules:", componentDescriptor.typeElement().getQualifiedName());
        for (Map.Entry entry : repeatedModules.asMap().entrySet()) {
            formatter.format("\n  %s also installs: ", ((ComponentDescriptor)entry.getKey()).typeElement().getQualifiedName());
            COMMA_SEPARATED_JOINER.appendTo(error, Iterables.transform((Iterable)((Iterable)entry.getValue()), m -> m.moduleElement().getQualifiedName()));
        }
        report.addError(error.toString());
    }

    private void validateRepeatedScopedDeclarations(ValidationReport.Builder report, ComponentDescriptor component, SetMultimap<ComponentDescriptor, ModuleDescriptor> modulesWithScopes) {
        ImmutableSet modules = (ImmutableSet)component.modules().stream().filter(this::hasScopedDeclarations).collect(DaggerStreams.toImmutableSet());
        modulesWithScopes.putAll((Object)component, (Iterable)modules);
        for (ComponentDescriptor childComponent : component.childComponents()) {
            this.validateRepeatedScopedDeclarations(report, childComponent, modulesWithScopes);
        }
        modulesWithScopes.removeAll((Object)component);
        SetMultimap repeatedModules = Multimaps.filterValues(modulesWithScopes, arg_0 -> ((ImmutableSet)modules).contains(arg_0));
        if (repeatedModules.isEmpty()) {
            return;
        }
        report.addError(this.repeatedModulesWithScopeError(component, (ImmutableSetMultimap<ComponentDescriptor, ModuleDescriptor>)ImmutableSetMultimap.copyOf((Multimap)repeatedModules)));
    }

    private boolean hasScopedDeclarations(ModuleDescriptor module) {
        return !this.moduleScopes(module).isEmpty();
    }

    private String repeatedModulesWithScopeError(ComponentDescriptor component, ImmutableSetMultimap<ComponentDescriptor, ModuleDescriptor> repeatedModules) {
        StringBuilder error = new StringBuilder().append(component.typeElement().getQualifiedName()).append(" repeats modules with scoped bindings or declarations:");
        repeatedModules.asMap().forEach((conflictingComponent, conflictingModules) -> {
            error.append("\n  - ").append(conflictingComponent.typeElement().getQualifiedName()).append(" also includes:");
            for (ModuleDescriptor conflictingModule : conflictingModules) {
                error.append("\n    - ").append(conflictingModule.moduleElement().getQualifiedName()).append(" with scopes: ").append(COMMA_SEPARATED_JOINER.join(this.moduleScopes(conflictingModule)));
            }
        });
        return error.toString();
    }

    private ImmutableSet<Scope> moduleScopes(ModuleDescriptor module) {
        return (ImmutableSet)module.allBindingDeclarations().stream().map(declaration -> this.injectionAnnotations.getScope(declaration.bindingElement().get())).filter(scope -> scope.isPresent() && !((Scope)scope.get()).isReusable()).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }
}

