/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.binding.AutoValue_Nullability;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XNullability;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

@AutoValue
public abstract class Nullability {
    public static final Nullability NOT_NULLABLE = new AutoValue_Nullability(false, (ImmutableSet<XAnnotation>)ImmutableSet.of());

    public static Nullability of(XElement element) {
        return new AutoValue_Nullability(Nullability.isKotlinTypeNullable(element), (ImmutableSet<XAnnotation>)((ImmutableSet)element.getAllAnnotations().stream().filter(annotation -> XAnnotations.getClassName(annotation).simpleName().contentEquals("Nullable")).collect(DaggerStreams.toImmutableSet())));
    }

    private static boolean isKotlinTypeNullable(XElement element) {
        if (XElements.isFromJavaSource(element)) {
            return false;
        }
        if (XElementKt.isMethod((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asMethod(element).getReturnType());
        }
        if (XElementKt.isVariableElement((XElement)element)) {
            return Nullability.isKotlinTypeNullable(XElements.asVariable(element).getType());
        }
        return false;
    }

    private static boolean isKotlinTypeNullable(XType type) {
        return type.getNullability() == XNullability.NULLABLE;
    }

    public abstract boolean isKotlinTypeNullable();

    public abstract ImmutableSet<XAnnotation> nullableAnnotations();

    public final boolean isNullable() {
        return this.isKotlinTypeNullable() || !this.nullableAnnotations().isEmpty();
    }

    Nullability() {
    }
}

