/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.base.ElementFormatter;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.model.DaggerAnnotation;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.Optional;
import javax.inject.Inject;

public final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final XProcessingEnv processingEnv;

    @Inject
    DependencyRequestFormatter(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public String format(DependencyRequest request) {
        if (!request.requestElement().isPresent()) {
            return "";
        }
        XElement requestElement = request.requestElement().get().xprocessing();
        if (XElementKt.isMethod((XElement)requestElement)) {
            return "    " + request.key() + " is " + this.componentMethodRequestVerb(request) + " at\n" + "        " + ElementFormatter.elementToString(requestElement);
        }
        if (XElementKt.isVariableElement((XElement)requestElement)) {
            return "    " + this.formatQualifier(request.key().qualifier()) + XTypes.toStableString(RequestKinds.requestType(request.kind(), request.key().type().xprocessing(), this.processingEnv)) + " is injected at\n" + "        " + ElementFormatter.elementToString(requestElement);
        }
        if (XElementKt.isTypeElement((XElement)requestElement)) {
            return "";
        }
        throw new IllegalStateException("Invalid request element " + requestElement);
    }

    @CanIgnoreReturnValue
    public StringBuilder appendFormatLine(StringBuilder builder, DependencyRequest dependencyRequest) {
        String formatted = this.format(dependencyRequest);
        if (!formatted.isEmpty()) {
            builder.append('\n').append(formatted);
        }
        return builder;
    }

    private String formatQualifier(Optional<DaggerAnnotation> maybeQualifier) {
        return maybeQualifier.map(qualifier -> qualifier + " ").orElse("");
    }

    private String componentMethodRequestVerb(DependencyRequest request) {
        switch (request.kind()) {
            case FUTURE: 
            case PRODUCER: 
            case INSTANCE: 
            case LAZY: 
            case PROVIDER: 
            case PROVIDER_OF_LAZY: {
                return "requested";
            }
            case MEMBERS_INJECTION: {
                return "injected";
            }
        }
        throw new AssertionError((Object)("illegal request kind for method: " + request));
    }
}

