/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

public final class Expression {
    private final XType type;
    private final CodeBlock codeBlock;

    private Expression(XType type, CodeBlock codeBlock) {
        this.type = type;
        this.codeBlock = codeBlock;
    }

    public static Expression create(XType type, CodeBlock expression) {
        return new Expression(type, expression);
    }

    public static Expression create(XType type, String format, Object ... args) {
        return new Expression(type, CodeBlock.of((String)format, (Object[])args));
    }

    public Expression castTo(XType newType) {
        return Expression.create(newType, CodeBlock.of((String)"($T) $L", (Object[])new Object[]{newType.getTypeName(), this.codeBlock}));
    }

    public Expression box() {
        return XTypes.isPrimitive((XType)this.type) ? this.castTo(this.type.boxed()) : this;
    }

    public XType type() {
        return this.type;
    }

    public CodeBlock codeBlock() {
        return this.codeBlock;
    }

    public String toString() {
        return String.format("[%s] %s", this.type.getTypeName(), this.codeBlock);
    }
}

