/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;

public final class ComponentDescriptorFactory {
    private final XProcessingEnv processingEnv;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final ModuleDescriptor.Factory moduleDescriptorFactory;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerSuperficialValidation superficialValidation;

    @Inject
    ComponentDescriptorFactory(XProcessingEnv processingEnv, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation) {
        this.processingEnv = processingEnv;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.injectionAnnotations = injectionAnnotations;
        this.superficialValidation = superficialValidation;
    }

    public ComponentDescriptor rootComponentDescriptor(XTypeElement typeElement) {
        Optional<ComponentAnnotation> annotation = ComponentAnnotation.rootComponentAnnotation(typeElement, this.superficialValidation);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a component annotation", (Object)typeElement);
        return this.create(typeElement, annotation.get());
    }

    public ComponentDescriptor subcomponentDescriptor(XTypeElement typeElement) {
        Optional<ComponentAnnotation> annotation = ComponentAnnotation.subcomponentAnnotation(typeElement, this.superficialValidation);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a subcomponent annotation", (Object)typeElement);
        return this.create(typeElement, annotation.get());
    }

    public ComponentDescriptor moduleComponentDescriptor(XTypeElement typeElement) {
        Optional<ModuleAnnotation> annotation = ModuleAnnotation.moduleAnnotation((XElement)typeElement, this.superficialValidation);
        Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a module annotation", (Object)typeElement);
        return this.create(typeElement, ComponentAnnotation.fromModuleAnnotation(annotation.get()));
    }

    private ComponentDescriptor create(XTypeElement typeElement, ComponentAnnotation componentAnnotation) {
        ImmutableSet<XTypeElement> enclosedCreators;
        ImmutableSet componentDependencies = (ImmutableSet)componentAnnotation.dependencyTypes().stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet());
        ImmutableMap.Builder dependenciesByDependencyMethod = ImmutableMap.builder();
        for (ComponentRequirement componentDependency : componentDependencies) {
            XTypeElements.getAllMethods((XTypeElement)componentDependency.typeElement()).stream().filter(ComponentDescriptor::isComponentContributionMethod).forEach(method -> dependenciesByDependencyMethod.put(method, (Object)componentDependency));
        }
        ImmutableSet modules = componentAnnotation.isRealComponent() ? componentAnnotation.modules() : ImmutableSet.of((Object)typeElement);
        ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Collection<XTypeElement>)modules);
        ImmutableSet subcomponentsFromModules = (ImmutableSet)transitiveModules.stream().flatMap(transitiveModule -> transitiveModule.subcomponentDeclarations().stream()).map(SubcomponentDeclaration::subcomponentType).map(this::subcomponentDescriptor).collect(DaggerStreams.toImmutableSet());
        ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
        ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
        ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
        if (componentAnnotation.isRealComponent()) {
            for (XMethodElement componentMethod : XTypeElements.getAllUnimplementedMethods((XTypeElement)typeElement)) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentAnnotation, typeElement, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                componentMethodDescriptor.subcomponent().ifPresent(subcomponent -> {
                    if (componentMethodDescriptor.dependencyRequest().isPresent()) {
                        subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, subcomponent);
                    } else {
                        subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, subcomponent);
                    }
                });
            }
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement, ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation))).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((XTypeElement)Iterables.getOnlyElement(enclosedCreators), this.dependencyRequestFactory));
        ImmutableSet scopes = this.injectionAnnotations.getScopes((XElement)typeElement);
        if (componentAnnotation.isProduction()) {
            scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.processingEnv)).build();
        }
        return ComponentDescriptor.create(componentAnnotation, typeElement, (ImmutableSet<ComponentRequirement>)componentDependencies, transitiveModules, (ImmutableMap<XMethodElement, ComponentRequirement>)dependenciesByDependencyMethod.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules, (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor>)componentMethodsBuilder.build(), creatorDescriptor);
    }

    private ComponentDescriptor.ComponentMethodDescriptor getDescriptorForComponentMethod(ComponentAnnotation componentAnnotation, XTypeElement componentElement, XMethodElement componentMethod) {
        ComponentDescriptor.ComponentMethodDescriptor.Builder descriptor = ComponentDescriptor.ComponentMethodDescriptor.builder(componentMethod);
        XMethodType resolvedComponentMethod = componentMethod.asMemberOf(componentElement.getType());
        XType returnType = resolvedComponentMethod.getReturnType();
        if (XTypes.isDeclared((XType)returnType) && !this.injectionAnnotations.getQualifier((XElement)componentMethod).isPresent()) {
            XTypeElement returnTypeElement = returnType.getTypeElement();
            if (returnTypeElement.hasAnyAnnotation(ComponentAnnotation.subcomponentAnnotations())) {
                return descriptor.subcomponent(this.subcomponentDescriptor(returnTypeElement)).build();
            }
            if (ConfigurationAnnotations.isSubcomponentCreator((XElement)returnTypeElement)) {
                descriptor.subcomponent(this.subcomponentDescriptor(returnTypeElement.getEnclosingTypeElement()));
            }
        }
        switch (componentMethod.getParameters().size()) {
            case 0: {
                Preconditions.checkArgument((!XTypeKt.isVoid((XType)returnType) ? 1 : 0) != 0, (String)"component method cannot be void: %s", (Object)componentMethod);
                descriptor.dependencyRequest(componentAnnotation.isProduction() ? this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod) : this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            case 1: {
                Preconditions.checkArgument((XTypeKt.isVoid((XType)returnType) || returnType.getTypeName().equals((Object)((XType)resolvedComponentMethod.getParameterTypes().get(0)).getTypeName()) ? 1 : 0) != 0, (String)"members injection method must return void or parameter type: %s", (Object)componentMethod);
                descriptor.dependencyRequest(this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            default: {
                throw new IllegalArgumentException("component method has too many parameters: " + componentMethod);
            }
        }
        return descriptor.build();
    }
}

