/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.BindingRepresentation;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.ExperimentalSwitchingProviderDependencyRepresentation;
import dagger.internal.codegen.writing.MembersInjectionBindingRepresentation;
import dagger.internal.codegen.writing.MembersInjectionRequestRepresentation;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.ProductionBindingRepresentation;
import dagger.internal.codegen.writing.ProvisionBindingRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@PerComponentImplementation
public final class ComponentRequestRepresentations {
    private final Optional<ComponentRequestRepresentations> parent;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final MembersInjectionBindingRepresentation.Factory membersInjectionBindingRepresentationFactory;
    private final ProvisionBindingRepresentation.Factory provisionBindingRepresentationFactory;
    private final ProductionBindingRepresentation.Factory productionBindingRepresentationFactory;
    private final ExperimentalSwitchingProviderDependencyRepresentation.Factory experimentalSwitchingProviderDependencyRepresentationFactory;
    private final XProcessingEnv processingEnv;
    private final Map<Binding, BindingRepresentation> representations = new HashMap<Binding, BindingRepresentation>();
    private final Map<Binding, ExperimentalSwitchingProviderDependencyRepresentation> experimentalSwitchingProviderDependencyRepresentations = new HashMap<Binding, ExperimentalSwitchingProviderDependencyRepresentation>();

    @Inject
    ComponentRequestRepresentations(@ParentComponent Optional<ComponentRequestRepresentations> parent, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, MembersInjectionBindingRepresentation.Factory membersInjectionBindingRepresentationFactory, ProvisionBindingRepresentation.Factory provisionBindingRepresentationFactory, ProductionBindingRepresentation.Factory productionBindingRepresentationFactory, ExperimentalSwitchingProviderDependencyRepresentation.Factory experimentalSwitchingProviderDependencyRepresentationFactory, XProcessingEnv processingEnv) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.membersInjectionBindingRepresentationFactory = membersInjectionBindingRepresentationFactory;
        this.provisionBindingRepresentationFactory = provisionBindingRepresentationFactory;
        this.productionBindingRepresentationFactory = productionBindingRepresentationFactory;
        this.experimentalSwitchingProviderDependencyRepresentationFactory = experimentalSwitchingProviderDependencyRepresentationFactory;
        this.componentRequirementExpressions = (ComponentRequirementExpressions)Preconditions.checkNotNull((Object)componentRequirementExpressions);
        this.processingEnv = processingEnv;
    }

    public Expression getDependencyExpression(BindingRequest request, ClassName requestingClass) {
        return this.getRequestRepresentation(request).getDependencyExpression(requestingClass);
    }

    Expression getDependencyExpressionForComponentMethod(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation) {
        return this.getRequestRepresentation(request).getDependencyExpressionForComponentMethod(componentMethod, componentImplementation);
    }

    CodeBlock getCreateMethodArgumentsCodeBlock(ContributionBinding binding, ClassName requestingClass) {
        return CodeBlocks.makeParametersCodeBlock(this.getCreateMethodArgumentsCodeBlocks(binding, requestingClass));
    }

    private ImmutableList<CodeBlock> getCreateMethodArgumentsCodeBlocks(ContributionBinding binding, ClassName requestingClass) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        if (binding.requiresModuleInstance()) {
            arguments.add((Object)this.componentRequirementExpressions.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().getType()), requestingClass));
        }
        binding.dependencies().stream().map(dependency -> ComponentRequestRepresentations.frameworkRequest(binding, dependency)).map(request -> this.getDependencyExpression((BindingRequest)request, requestingClass)).map(Expression::codeBlock).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return arguments.build();
    }

    private static BindingRequest frameworkRequest(ContributionBinding binding, DependencyRequest dependency) {
        FrameworkType frameworkType = FrameworkTypeMapper.forBindingType(binding.bindingType()).getFrameworkType(dependency.kind());
        return BindingRequest.bindingRequest(dependency.key(), frameworkType);
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        XType dependencyType = dependencyRequest.key().type().xprocessing();
        BindingRequest bindingRequest = BindingRequest.bindingRequest(dependencyRequest);
        Expression dependencyExpression = this.getDependencyExpression(bindingRequest, requestingClass);
        if (dependencyRequest.kind().equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(XProcessingEnvs.erasure((XType)dependencyType, (XProcessingEnv)this.processingEnv));
        }
        return dependencyExpression;
    }

    public MethodSpec getComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.dependencyRequest().isPresent());
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        return MethodSpecs.overriding((XMethodElement)componentMethod.methodElement(), (XType)this.graph.componentTypeElement().getType()).addCode(request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? this.getMembersInjectionComponentMethodImplementation(request, componentMethod) : this.getContributionComponentMethodImplementation(request, componentMethod)).build();
    }

    private CodeBlock getMembersInjectionComponentMethodImplementation(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)request.isRequestKind(RequestKind.MEMBERS_INJECTION));
        XMethodElement methodElement = componentMethod.methodElement();
        RequestRepresentation requestRepresentation = this.getRequestRepresentation(request);
        MembersInjectionBinding binding = ((MembersInjectionRequestRepresentation)requestRepresentation).binding();
        if (binding.injectionSites().isEmpty()) {
            return XTypeKt.isVoid((XType)methodElement.getReturnType()) ? CodeBlock.of((String)"", (Object[])new Object[0]) : CodeBlock.of((String)"return $L;", (Object[])new Object[]{XElements.getSimpleName((XElement)((XElement)Iterables.getOnlyElement((Iterable)methodElement.getParameters())))});
        }
        Expression expression = this.getComponentMethodExpression(requestRepresentation, componentMethod);
        return XTypeKt.isVoid((XType)methodElement.getReturnType()) ? CodeBlock.of((String)"$L;", (Object[])new Object[]{expression.codeBlock()}) : CodeBlock.of((String)"return $L;", (Object[])new Object[]{expression.codeBlock()});
    }

    private CodeBlock getContributionComponentMethodImplementation(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((!request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? 1 : 0) != 0);
        Expression expression = this.getComponentMethodExpression(this.getRequestRepresentation(request), componentMethod);
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{expression.codeBlock()});
    }

    private Expression getComponentMethodExpression(RequestRepresentation requestRepresentation, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Expression expression = requestRepresentation.getDependencyExpressionForComponentMethod(componentMethod, this.componentImplementation);
        XType returnType = componentMethod.methodElement().asMemberOf(this.componentImplementation.graph().componentTypeElement().getType()).getReturnType();
        return !XTypeKt.isVoid((XType)returnType) && !XTypes.isAssignableTo((XType)expression.type(), (XType)returnType) ? expression.castTo(returnType) : expression;
    }

    RequestRepresentation getRequestRepresentation(BindingRequest request) {
        Optional<Binding> localBinding;
        Optional<Binding> optional = localBinding = request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? this.graph.localMembersInjectionBinding(request.key()) : this.graph.localContributionBinding(request.key());
        if (localBinding.isPresent()) {
            return this.getBindingRepresentation(localBinding.get()).getRequestRepresentation(request);
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getRequestRepresentation(request);
    }

    private BindingRepresentation getBindingRepresentation(Binding binding) {
        return Util.reentrantComputeIfAbsent(this.representations, binding, this::getBindingRepresentationUncached);
    }

    private BindingRepresentation getBindingRepresentationUncached(Binding binding) {
        switch (binding.bindingType()) {
            case MEMBERS_INJECTION: {
                return this.membersInjectionBindingRepresentationFactory.create((MembersInjectionBinding)binding);
            }
            case PROVISION: {
                return this.provisionBindingRepresentationFactory.create((ProvisionBinding)binding);
            }
            case PRODUCTION: {
                return this.productionBindingRepresentationFactory.create((ProductionBinding)binding);
            }
        }
        throw new AssertionError();
    }

    ExperimentalSwitchingProviderDependencyRepresentation getExperimentalSwitchingProviderDependencyRepresentation(BindingRequest request) {
        Preconditions.checkState((boolean)this.componentImplementation.compilerMode().isExperimentalMergedMode(), (Object)"Compiler mode should be experimentalMergedMode!");
        Optional<Binding> localBinding = this.graph.localContributionBinding(request.key());
        if (localBinding.isPresent()) {
            return Util.reentrantComputeIfAbsent(this.experimentalSwitchingProviderDependencyRepresentations, localBinding.get(), binding -> this.experimentalSwitchingProviderDependencyRepresentationFactory.create((ProvisionBinding)binding));
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getExperimentalSwitchingProviderDependencyRepresentation(request);
    }
}

