/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import javax.inject.Inject;

final class ProducesMethodValidator
extends BindingMethodValidator {
    @Inject
    ProducesMethodValidator(XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(TypeNames.PRODUCES, TypeNames.PRODUCER_MODULE, BindingMethodValidator.Abstractness.MUST_BE_CONCRETE, BindingMethodValidator.ExceptionSuperclass.EXCEPTION, BindingElementValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, processingEnv, dependencyRequestValidator, injectionAnnotations);
    }

    @Override
    protected String elementsIntoSetNotASetMessage() {
        return "@Produces methods of type set values must return a Set or ListenableFuture of Set";
    }

    @Override
    protected String badTypeMessage() {
        return "@Produces methods can return only a primitive, an array, a type variable, a declared type, or a ListenableFuture of one of those types";
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(ProducesMethodValidator.this, method);
            this.method = method;
        }

        @Override
        protected void checkAdditionalMethodProperties() {
            this.checkNullable();
        }

        private void checkNullable() {
            if (ConfigurationAnnotations.getNullableAnnotation((XElement)this.method).isPresent()) {
                this.report.addWarning("@Nullable on @Produces methods does not do anything");
            }
        }

        @Override
        protected void checkKeyType(XType keyType) {
            this.unwrapListenableFuture(keyType).ifPresent(x$0 -> super.checkKeyType((XType)x$0));
        }

        @Override
        protected void checkSetValuesType() {
            this.unwrapListenableFuture(this.method.getReturnType()).ifPresent(this::checkSetValuesType);
        }

        private Optional<XType> unwrapListenableFuture(XType type) {
            if (XTypes.isTypeOf((XType)type, (ClassName)TypeNames.LISTENABLE_FUTURE)) {
                if (type.getTypeArguments().isEmpty()) {
                    this.report.addError("@Produces methods cannot return a raw ListenableFuture");
                    return Optional.empty();
                }
                return Optional.of((XType)Iterables.getOnlyElement((Iterable)type.getTypeArguments()));
            }
            return Optional.of(type);
        }
    }
}

