/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;

final class ExperimentalSwitchingProviderDependencyRepresentation {
    private final ProvisionBinding binding;
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final BindsTypeChecker bindsTypeChecker;
    private final XProcessingEnv processingEnv;
    private final XType type;

    @AssistedInject
    ExperimentalSwitchingProviderDependencyRepresentation(@Assisted ProvisionBinding binding, ComponentImplementation componentImplementation, BindsTypeChecker bindsTypeChecker, XProcessingEnv processingEnv) {
        this.binding = binding;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
        this.type = this.isDelegateSetValuesBinding() ? XProcessingEnvs.erasure((XType)processingEnv.requireType((TypeName)TypeNames.COLLECTION), (XProcessingEnv)processingEnv) : binding.contributedType();
    }

    Expression getDependencyExpression(RequestKind requestKind, ProvisionBinding requestingBinding) {
        int index = this.findIndexOfDependency(requestingBinding);
        XType frameworkType = this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((TypeName)FrameworkType.PROVIDER.frameworkClassName()), new XType[0]);
        Expression expression = FrameworkType.PROVIDER.to(requestKind, Expression.create(frameworkType, CodeBlock.of((String)"(($T) dependencies[$L])", (Object[])new Object[]{frameworkType.getTypeName(), index})), this.processingEnv);
        if (this.usesExplicitTypeCast(expression, requestKind)) {
            return expression.castTo(this.type);
        }
        if (this.usesErasedTypeCast(requestKind)) {
            return expression.castTo(XProcessingEnvs.erasure((XType)this.type, (XProcessingEnv)this.processingEnv));
        }
        return expression;
    }

    private int findIndexOfDependency(ProvisionBinding requestingBinding) {
        return ((ImmutableList)requestingBinding.dependencies().stream().map(DependencyRequest::key).collect(DaggerStreams.toImmutableList())).indexOf((Object)this.binding.key()) + (requestingBinding.requiresModuleInstance() && requestingBinding.contributingModule().isPresent() ? 1 : 0);
    }

    private boolean isDelegateSetValuesBinding() {
        return this.binding.kind().equals((Object)BindingKind.DELEGATE) && this.binding.contributionType().equals((Object)ContributionType.SET_VALUES);
    }

    private boolean usesExplicitTypeCast(Expression expression, RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !this.bindsTypeChecker.isAssignable(expression.type(), this.type, this.binding.contributionType()) && Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName());
    }

    private boolean usesErasedTypeCast(RequestKind requestKind) {
        return requestKind.equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(this.type, this.shardImplementation.name().packageName()) && Accessibility.isRawTypeAccessible(this.type, this.shardImplementation.name().packageName());
    }

    @AssistedFactory
    static interface Factory {
        public ExperimentalSwitchingProviderDependencyRepresentation create(ProvisionBinding var1);
    }
}

