/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import javax.lang.model.element.Modifier;

final class DependencyMethodProducerCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ContributionBinding binding;
    private final ComponentImplementation componentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final BindingGraph graph;

    @AssistedInject
    DependencyMethodProducerCreationExpression(@Assisted ContributionBinding binding, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.graph = graph;
    }

    @Override
    public CodeBlock creationExpression() {
        ComponentRequirement dependency = this.graph.componentDescriptor().getDependencyThatDefinesMethod(this.binding.bindingElement().get());
        FieldSpec dependencyField = FieldSpec.builder((TypeName)dependency.typeElement().getClassName(), (String)dependency.variableName(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(this.componentRequirementExpressions.getExpressionDuringInitialization(dependency, this.componentImplementation.name().nestedClass("Anonymous"))).build();
        TypeName keyType = this.binding.key().type().xprocessing().getTypeName();
        return CodeBlock.of((String)"$L", (Object[])new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)TypeNames.dependencyMethodProducerOf(keyType)).addField(dependencyField).addMethod(MethodSpec.methodBuilder((String)"callDependencyMethod").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeNames.listenableFutureOf(keyType)).addStatement("return $N.$L()", new Object[]{dependencyField, XElements.getSimpleName((XElement)this.binding.bindingElement().get())}).build()).build()});
    }

    @AssistedFactory
    static interface Factory {
        public DependencyMethodProducerCreationExpression create(ContributionBinding var1);
    }
}

