/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public final class MethodSignatureFormatter
extends Formatter<XExecutableElement> {
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    MethodSignatureFormatter(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    public Formatter<XMethodElement> typedFormatter(final XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)type));
        return new Formatter<XMethodElement>(){

            @Override
            public String format(XMethodElement method) {
                return MethodSignatureFormatter.this.format((XExecutableElement)method, (XExecutableType)method.asMemberOf(type), XElements.closestEnclosingTypeElement((XElement)method));
            }
        };
    }

    @Override
    public String format(XExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(XExecutableElement method, Optional<XType> container) {
        return container.isPresent() ? this.format(method, method.asMemberOf(container.get()), container.get().getTypeElement()) : this.format(method, method.getExecutableType(), XElements.closestEnclosingTypeElement((XElement)method));
    }

    private String format(XExecutableElement method, XExecutableType methodType, XTypeElement container) {
        StringBuilder builder = new StringBuilder();
        List annotations = method.getAllAnnotations();
        if (!annotations.isEmpty()) {
            Iterator annotationIterator = annotations.iterator();
            int i = 0;
            while (annotationIterator.hasNext()) {
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(MethodSignatureFormatter.formatAnnotation((XAnnotation)annotationIterator.next()));
                ++i;
            }
            builder.append(' ');
        }
        if (XElements.getSimpleName((XElement)method).contentEquals("<init>")) {
            builder.append(container.getQualifiedName());
        } else {
            builder.append(MethodSignatureFormatter.nameOfType(((XMethodType)methodType).getReturnType())).append(' ').append(container.getQualifiedName()).append('.').append(XElements.getSimpleName((XElement)method));
        }
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == methodType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator parameters = method.getParameters().iterator();
        Iterator parameterTypes = methodType.getParameterTypes().iterator();
        int i = 0;
        while (parameters.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            this.appendParameter(builder, (XVariableElement)parameters.next(), (XType)parameterTypes.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    private void appendParameter(StringBuilder builder, XVariableElement parameter, XType parameterType) {
        this.injectionAnnotations.getQualifier((XElement)parameter).ifPresent(qualifier -> builder.append(MethodSignatureFormatter.formatAnnotation(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(parameterType));
    }

    private static String nameOfType(XType type) {
        return DiagnosticFormatting.stripCommonTypePrefixes(type.toString());
    }

    private static String formatAnnotation(XAnnotation annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(XAnnotations.toString((XAnnotation)annotation));
    }
}

