/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.langmodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import dagger.Reusable;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

@Reusable
public final class DaggerElements
implements Elements,
ClearableCache {
    private final Map<TypeElement, ImmutableSet<ExecutableElement>> getLocalAndInheritedMethodsCache = new HashMap<TypeElement, ImmutableSet<ExecutableElement>>();
    private final Elements elements;
    private final Types types;
    public static final Comparator<Element> DECLARATION_ORDER = Comparator.comparing(element -> DaggerElements.siblings(element).indexOf(element));
    private static final SimpleTypeVisitor8<String, Void> JVM_DESCRIPTOR_TYPE_VISITOR = new SimpleTypeVisitor8<String, Void>(){

        @Override
        public String visitArray(ArrayType arrayType, Void v) {
            return "[" + DaggerElements.getDescriptor(arrayType.getComponentType());
        }

        @Override
        public String visitDeclared(DeclaredType declaredType, Void v) {
            return "L" + this.getInternalName(declaredType.asElement()) + ";";
        }

        @Override
        public String visitError(ErrorType errorType, Void v) {
            return this.visitDeclared((DeclaredType)errorType, v);
        }

        @Override
        public String visitExecutable(ExecutableType executableType, Void v) {
            String parameterDescriptors = executableType.getParameterTypes().stream().map(x$0 -> DaggerElements.getDescriptor(x$0)).collect(Collectors.joining());
            String returnDescriptor = DaggerElements.getDescriptor(executableType.getReturnType());
            return "(" + parameterDescriptors + ")" + returnDescriptor;
        }

        @Override
        public String visitIntersection(IntersectionType intersectionType, Void v) {
            return DaggerElements.getDescriptor(intersectionType.getBounds().get(0));
        }

        @Override
        public String visitNoType(NoType noType, Void v) {
            return "V";
        }

        @Override
        public String visitPrimitive(PrimitiveType primitiveType, Void v) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case INT: {
                    return "I";
                }
                case LONG: {
                    return "J";
                }
                case CHAR: {
                    return "C";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
            throw new IllegalArgumentException("Unknown primitive type.");
        }

        @Override
        public String visitTypeVariable(TypeVariable typeVariable, Void v) {
            return DaggerElements.getDescriptor(typeVariable.getUpperBound());
        }

        @Override
        public String defaultAction(TypeMirror typeMirror, Void v) {
            throw new IllegalArgumentException("Unsupported type: " + typeMirror);
        }

        @Override
        public String visitWildcard(WildcardType wildcardType, Void v) {
            return "";
        }

        private String getInternalName(Element element) {
            try {
                TypeElement typeElement = MoreElements.asType((Element)element);
                switch (typeElement.getNestingKind()) {
                    case TOP_LEVEL: {
                        return typeElement.getQualifiedName().toString().replace('.', '/');
                    }
                    case MEMBER: {
                        return this.getInternalName(typeElement.getEnclosingElement()) + "$" + typeElement.getSimpleName();
                    }
                }
                throw new IllegalArgumentException("Unsupported nesting kind.");
            }
            catch (IllegalArgumentException typeElement) {
                if (element instanceof QualifiedNameable) {
                    QualifiedNameable qualifiedNameElement = (QualifiedNameable)element;
                    return qualifiedNameElement.getQualifiedName().toString().replace('.', '/');
                }
                return element.getSimpleName().toString();
            }
        }
    };

    public DaggerElements(Elements elements, Types types) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
    }

    public static boolean transitivelyEncloses(XElement encloser, XElement enclosed) {
        return DaggerElements.transitivelyEncloses(XConverters.toJavac((XElement)encloser), XConverters.toJavac((XElement)enclosed));
    }

    public static boolean transitivelyEncloses(Element encloser, Element enclosed) {
        for (Element current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(encloser)) continue;
            return true;
        }
        return false;
    }

    public ImmutableSet<ExecutableElement> getLocalAndInheritedMethods(TypeElement type) {
        return this.getLocalAndInheritedMethodsCache.computeIfAbsent(type, k -> MoreElements.getLocalAndInheritedMethods((TypeElement)type, (Types)this.types, (Elements)this.elements));
    }

    @Override
    public TypeElement getTypeElement(CharSequence name) {
        return this.elements.getTypeElement(name);
    }

    public TypeElement getTypeElement(ClassName className) {
        return this.getTypeElement(className.canonicalName());
    }

    public static TypeElement closestEnclosingTypeElement(Element element) {
        for (Element current = element; current != null; current = current.getEnclosingElement()) {
            if (!MoreElements.isType((Element)current)) continue;
            return MoreElements.asType((Element)current);
        }
        throw new IllegalStateException("There is no enclosing TypeElement for: " + element);
    }

    private static List<? extends Element> siblings(Element element) {
        return element.getKind().equals((Object)ElementKind.PARAMETER) ? MoreElements.asExecutable((Element)element.getEnclosingElement()).getParameters() : element.getEnclosingElement().getEnclosedElements();
    }

    public static boolean isAnyAnnotationPresent(Element element, Iterable<ClassName> annotationClasses) {
        for (ClassName annotation : annotationClasses) {
            if (!DaggerElements.isAnnotationPresent(element, annotation)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean isAnyAnnotationPresent(Element element, ClassName first, ClassName ... otherAnnotations) {
        return DaggerElements.isAnyAnnotationPresent(element, Lists.asList((Object)first, (Object[])otherAnnotations));
    }

    public static boolean isAnnotationPresent(Element element, ClassName annotationName) {
        return DaggerElements.getAnnotationMirror(element, annotationName).isPresent();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, ClassName annotationName) {
        String annotationClassName = annotationName.canonicalName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = MoreElements.asType((Element)annotationMirror.getAnnotationType().asElement());
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static ImmutableSet<? extends AnnotationMirror> getAnnotatedAnnotations(Element element, ClassName annotationName) {
        return (ImmutableSet)element.getAnnotationMirrors().stream().filter(input -> DaggerElements.isAnnotationPresent(input.getAnnotationType().asElement(), annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static String getFieldDescriptor(VariableElement element) {
        return element.getSimpleName() + ":" + DaggerElements.getDescriptor(element.asType());
    }

    public static String getMethodDescriptor(XMethodElement element) {
        return DaggerElements.getMethodDescriptor(XConverters.toJavac((XExecutableElement)element));
    }

    public static String getMethodDescriptor(ExecutableElement element) {
        return element.getSimpleName() + DaggerElements.getDescriptor(element.asType());
    }

    private static String getDescriptor(TypeMirror t) {
        return t.accept(JVM_DESCRIPTOR_TYPE_VISITOR, null);
    }

    @Override
    public PackageElement getPackageElement(CharSequence name) {
        return this.elements.getPackageElement(name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.elements.getElementValuesWithDefaults(a);
    }

    public Map<String, ? extends AnnotationValue> getElementValuesWithDefaultsByName(AnnotationMirror a) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.getElementValuesWithDefaults(a).forEach((k, v) -> builder.put((Object)k.getSimpleName().toString(), v));
        return builder.build();
    }

    @Override
    public String getDocComment(Element e) {
        return this.elements.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.elements.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.elements.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.elements.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.elements.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.elements.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.elements.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.elements.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.elements.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.elements.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.elements.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.elements.isFunctionalInterface(type);
    }

    @Override
    public void clearCache() {
        this.getLocalAndInheritedMethodsCache.clear();
    }
}

