/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.javapoet;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import javax.lang.model.type.TypeMirror;

public final class Expression {
    private final TypeMirror type;
    private final CodeBlock codeBlock;

    private Expression(TypeMirror type, CodeBlock codeBlock) {
        this.type = type;
        this.codeBlock = codeBlock;
    }

    public static Expression create(XType type, CodeBlock expression) {
        return Expression.create(XConverters.toJavac((XType)type), expression);
    }

    public static Expression create(TypeMirror type, CodeBlock expression) {
        return new Expression(type, expression);
    }

    public static Expression create(XType type, String format, Object ... args) {
        return Expression.create(XConverters.toJavac((XType)type), format, args);
    }

    public static Expression create(TypeMirror type, String format, Object ... args) {
        return Expression.create(type, CodeBlock.of((String)format, (Object[])args));
    }

    public Expression castTo(XType newType) {
        return this.castTo(XConverters.toJavac((XType)newType));
    }

    public Expression castTo(TypeMirror newType) {
        return Expression.create(newType, "($T) $L", newType, this.codeBlock);
    }

    public Expression box(DaggerTypes types) {
        return this.type.getKind().isPrimitive() ? this.castTo(types.boxedClass(MoreTypes.asPrimitiveType((TypeMirror)this.type)).asType()) : this;
    }

    public TypeMirror type() {
        return this.type;
    }

    public CodeBlock codeBlock() {
        return this.codeBlock;
    }

    public String toString() {
        return String.format("[%s] %s", this.type, this.codeBlock);
    }
}

