/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;

final class InjectionSiteFactory {
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final DependencyRequestFactory dependencyRequestFactory;

    @Inject
    InjectionSiteFactory(DaggerTypes types, DaggerElements elements, DependencyRequestFactory dependencyRequestFactory) {
        this.types = types;
        this.elements = elements;
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    ImmutableSortedSet<MembersInjectionBinding.InjectionSite> getInjectionSites(XType type) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)type));
        return this.getInjectionSites(MoreTypes.asDeclared((TypeMirror)XConverters.toJavac((XType)type)));
    }

    ImmutableSortedSet<MembersInjectionBinding.InjectionSite> getInjectionSites(DeclaredType declaredType) {
        HashSet injectionSites = new HashSet();
        ArrayList<TypeElement> ancestors = new ArrayList<TypeElement>();
        InjectionSiteVisitor injectionSiteVisitor = new InjectionSiteVisitor();
        Optional<DeclaredType> currentType = Optional.of(declaredType);
        while (currentType.isPresent()) {
            DeclaredType type = currentType.get();
            ancestors.add(MoreElements.asType((Element)type.asElement()));
            for (Element element : type.asElement().getEnclosedElements()) {
                ((Optional)injectionSiteVisitor.visit(element, type)).ifPresent(injectionSites::add);
            }
            currentType = this.types.nonObjectSuperclass(currentType.get());
        }
        return ImmutableSortedSet.copyOf(Comparator.comparing(injectionSite -> ancestors.indexOf(injectionSite.element().getEnclosingElement())).reversed().thenComparing(injectionSite -> injectionSite.element().getKind()).thenComparing(MembersInjectionBinding.InjectionSite::element, DaggerElements.DECLARATION_ORDER), injectionSites);
    }

    private final class InjectionSiteVisitor
    extends ElementKindVisitor8<Optional<MembersInjectionBinding.InjectionSite>, DeclaredType> {
        private final SetMultimap<String, ExecutableElement> subclassMethodMap;

        InjectionSiteVisitor() {
            super(Optional.empty());
            this.subclassMethodMap = LinkedHashMultimap.create();
        }

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitExecutableAsMethod(ExecutableElement method, DeclaredType type) {
            this.subclassMethodMap.put((Object)method.getSimpleName().toString(), (Object)method);
            if (!this.shouldBeInjected(method)) {
                return Optional.empty();
            }
            String methodName = method.getSimpleName().toString();
            TypeElement enclosingType = MoreElements.asType((Element)method.getEnclosingElement());
            for (ExecutableElement subclassMethod : this.subclassMethodMap.get((Object)methodName)) {
                if (method == subclassMethod || !InjectionSiteFactory.this.elements.overrides(subclassMethod, method, enclosingType)) continue;
                return Optional.empty();
            }
            ExecutableType resolved = MoreTypes.asExecutable((TypeMirror)InjectionSiteFactory.this.types.asMemberOf(type, method));
            return Optional.of(MembersInjectionBinding.InjectionSite.method(method, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), resolved.getParameterTypes())));
        }

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitVariableAsField(VariableElement field, DeclaredType type) {
            if (!this.shouldBeInjected(field)) {
                return Optional.empty();
            }
            TypeMirror resolved = InjectionSiteFactory.this.types.asMemberOf(type, field);
            return Optional.of(MembersInjectionBinding.InjectionSite.field(field, InjectionSiteFactory.this.dependencyRequestFactory.forRequiredResolvedVariable(field, resolved)));
        }

        private boolean shouldBeInjected(Element injectionSite) {
            return InjectionAnnotations.hasInjectAnnotation(injectionSite) && !injectionSite.getModifiers().contains((Object)Modifier.PRIVATE) && !injectionSite.getModifiers().contains((Object)Modifier.STATIC);
        }
    }
}

