/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AutoValue_FrameworkField;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.spi.model.BindingKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor8;

@AutoValue
public abstract class FrameworkField {
    private static final ElementVisitor<String, Binding> BINDING_ELEMENT_NAME = new ElementKindVisitor8<String, Binding>(){

        @Override
        protected String defaultAction(Element e, Binding p) {
            throw new IllegalArgumentException("Unexpected binding " + p);
        }

        @Override
        public String visitExecutableAsConstructor(ExecutableElement e, Binding p) {
            return (String)this.visit(e.getEnclosingElement(), p);
        }

        @Override
        public String visitExecutableAsMethod(ExecutableElement e, Binding p) {
            return e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Binding p) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
        }

        @Override
        public String visitVariableAsParameter(VariableElement e, Binding p) {
            return e.getSimpleName().toString();
        }
    };

    public static FrameworkField create(ClassName frameworkClassName, TypeName valueTypeName, String fieldName) {
        String suffix = frameworkClassName.simpleName();
        return new AutoValue_FrameworkField(ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{valueTypeName}), fieldName.endsWith(suffix) ? fieldName : fieldName + suffix);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<ClassName> frameworkClassName) {
        return FrameworkField.create(frameworkClassName.orElse(binding.frameworkType().frameworkClassName()), FrameworkField.fieldValueType(binding).getTypeName(), FrameworkField.frameworkFieldName(binding));
    }

    private static XType fieldValueType(ContributionBinding binding) {
        return binding.contributionType().isMultibinding() ? binding.contributedType() : binding.key().type().xprocessing();
    }

    private static String frameworkFieldName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = BINDING_ELEMENT_NAME.visit(XConverters.toJavac((XElement)binding.bindingElement().get()), binding);
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    public abstract ParameterizedTypeName type();

    public abstract String name();
}

