/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.binding.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.binding.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.producers.CancellationPolicy;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Scope;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class ComponentDescriptor {
    private final Supplier<ImmutableMap<XTypeElement, ComponentDescriptor>> childComponentsByBuilderType = Suppliers.memoize(() -> (ImmutableMap)this.childComponents().stream().filter(child -> child.creatorDescriptor().isPresent()).collect(DaggerStreams.toImmutableMap(child -> child.creatorDescriptor().get().typeElement(), child -> child)));
    private static final ImmutableSet<String> NON_CONTRIBUTING_OBJECT_METHOD_NAMES = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"clone", (Object)"getClass");

    static ComponentDescriptor create(ComponentAnnotation componentAnnotation, XTypeElement component, ImmutableSet<ComponentRequirement> componentDependencies, ImmutableSet<ModuleDescriptor> transitiveModules, ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod, ImmutableSet<Scope> scopes, ImmutableSet<ComponentDescriptor> subcomponentsFromModules, ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> subcomponentsByFactoryMethod, ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> subcomponentsByBuilderMethod, ImmutableSet<ComponentMethodDescriptor> componentMethods, Optional<ComponentCreatorDescriptor> creator) {
        AutoValue_ComponentDescriptor descriptor = new AutoValue_ComponentDescriptor(componentAnnotation, component, componentDependencies, transitiveModules, dependenciesByDependencyMethod, scopes, subcomponentsFromModules, subcomponentsByFactoryMethod, subcomponentsByBuilderMethod, componentMethods, creator);
        return descriptor;
    }

    public abstract ComponentAnnotation annotation();

    public final boolean isSubcomponent() {
        return this.annotation().isSubcomponent();
    }

    public final boolean isProduction() {
        return this.annotation().isProduction();
    }

    public final boolean isRealComponent() {
        return this.annotation().isRealComponent();
    }

    public abstract XTypeElement typeElement();

    public abstract ImmutableSet<ComponentRequirement> dependencies();

    public final ImmutableSet<ComponentRequirement> dependenciesAndConcreteModules() {
        return (ImmutableSet)Stream.concat(this.moduleTypes().stream().filter(dep -> !dep.isAbstract()).map(module -> ComponentRequirement.forModule(module.getType())), this.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public abstract ImmutableSet<ModuleDescriptor> modules();

    public final ImmutableSet<XTypeElement> moduleTypes() {
        return (ImmutableSet)this.modules().stream().map(ModuleDescriptor::moduleElement).collect(DaggerStreams.toImmutableSet());
    }

    @Memoized
    ImmutableSet<ComponentRequirement> requirements() {
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        this.modules().stream().filter(module -> module.bindings().stream().anyMatch(ContributionBinding::requiresModuleInstance)).map(module -> ComponentRequirement.forModule(module.moduleElement().getType())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        requirements.addAll(this.dependencies());
        requirements.addAll((Iterable)this.creatorDescriptor().map(ComponentCreatorDescriptor::boundInstanceRequirements).orElse(ImmutableSet.of()));
        return requirements.build();
    }

    public abstract ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod();

    public final ComponentRequirement getDependencyThatDefinesMethod(XElement method) {
        Preconditions.checkArgument((boolean)XElementKt.isMethod((XElement)method), (String)"method must be an executable element: %s", (Object)method);
        Preconditions.checkState((boolean)this.dependenciesByDependencyMethod().containsKey((Object)method), (String)"no dependency implements %s", (Object)method);
        return (ComponentRequirement)this.dependenciesByDependencyMethod().get((Object)method);
    }

    public abstract ImmutableSet<Scope> scopes();

    public final ImmutableSet<ComponentDescriptor> childComponents() {
        return ImmutableSet.builder().addAll((Iterable)this.childComponentsDeclaredByFactoryMethods().values()).addAll((Iterable)this.childComponentsDeclaredByBuilderEntryPoints().values()).addAll(this.childComponentsDeclaredByModules()).build();
    }

    abstract ImmutableSet<ComponentDescriptor> childComponentsDeclaredByModules();

    public abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByFactoryMethods();

    @Memoized
    public ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement() {
        return Maps.uniqueIndex(this.childComponents(), ComponentDescriptor::typeElement);
    }

    final Optional<ComponentMethodDescriptor> getFactoryMethodForChildComponent(ComponentDescriptor childComponent) {
        return Optional.ofNullable((ComponentMethodDescriptor)this.childComponentsDeclaredByFactoryMethods().inverse().get((Object)childComponent));
    }

    abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByBuilderEntryPoints();

    final ComponentDescriptor getChildComponentWithBuilderType(XTypeElement builderType) {
        return (ComponentDescriptor)Preconditions.checkNotNull((Object)((ComponentDescriptor)((ImmutableMap)this.childComponentsByBuilderType.get()).get((Object)builderType)), (String)"no child component found for builder type %s", (Object)builderType.getQualifiedName());
    }

    public abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    public Optional<ComponentMethodDescriptor> firstMatchingComponentMethod(BindingRequest request) {
        return Optional.ofNullable((ComponentMethodDescriptor)this.firstMatchingComponentMethods().get((Object)request));
    }

    @Memoized
    ImmutableMap<BindingRequest, ComponentMethodDescriptor> firstMatchingComponentMethods() {
        HashMap<BindingRequest, ComponentMethodDescriptor> methods = new HashMap<BindingRequest, ComponentMethodDescriptor>();
        for (ComponentMethodDescriptor method : this.entryPointMethods()) {
            methods.putIfAbsent(BindingRequest.bindingRequest(method.dependencyRequest().get()), method);
        }
        return ImmutableMap.copyOf(methods);
    }

    public final ImmutableSet<ComponentMethodDescriptor> entryPointMethods() {
        return (ImmutableSet)this.componentMethods().stream().filter(method -> method.dependencyRequest().isPresent()).collect(DaggerStreams.toImmutableSet());
    }

    public abstract Optional<ComponentCreatorDescriptor> creatorDescriptor();

    public final boolean hasCreator() {
        return !this.isSubcomponent() || this.creatorDescriptor().isPresent();
    }

    public final Optional<CancellationPolicy> cancellationPolicy() {
        return this.isProduction() ? Optional.ofNullable(XConverters.toJavac((XTypeElement)this.typeElement()).getAnnotation(CancellationPolicy.class)) : Optional.empty();
    }

    @Memoized
    public int hashCode() {
        return Objects.hash(this.typeElement(), this.annotation());
    }

    public abstract boolean equals(Object var1);

    static boolean isComponentContributionMethod(XMethodElement method) {
        return ComponentDescriptor.isComponentContributionMethod(XConverters.toJavac((XExecutableElement)method));
    }

    static boolean isComponentContributionMethod(ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !DaggerTypes.isTypeOf((TypeName)TypeName.OBJECT, method.getEnclosingElement().asType()) && !NON_CONTRIBUTING_OBJECT_METHOD_NAMES.contains((Object)method.getSimpleName().toString());
    }

    static boolean isComponentProductionMethod(XMethodElement method) {
        return ComponentDescriptor.isComponentContributionMethod(method) && DaggerTypes.isFutureType(method.getReturnType());
    }

    @AutoValue
    public static abstract class ComponentMethodDescriptor {
        public abstract XMethodElement methodElement();

        public abstract Optional<DependencyRequest> dependencyRequest();

        public abstract Optional<ComponentDescriptor> subcomponent();

        public TypeMirror resolvedReturnType(DaggerTypes types) {
            Preconditions.checkState((boolean)this.dependencyRequest().isPresent());
            XType returnType = this.methodElement().getReturnType();
            if (XTypes.isPrimitive((XType)returnType) || XTypeKt.isVoid((XType)returnType)) {
                return XConverters.toJavac((XType)returnType);
            }
            return BindingRequest.bindingRequest(this.dependencyRequest().get()).requestedType(this.dependencyRequest().get().key().type().java(), types);
        }

        public static Builder builder(XMethodElement method) {
            return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor.Builder().methodElement(method);
        }

        @AutoValue.Builder
        @CanIgnoreReturnValue
        public static interface Builder {
            public Builder methodElement(XMethodElement var1);

            public Builder dependencyRequest(DependencyRequest var1);

            public Builder subcomponent(ComponentDescriptor var1);

            @CheckReturnValue
            public ComponentMethodDescriptor build();
        }
    }
}

