/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.OptionalType;
import dagger.internal.codegen.base.ProducerAnnotations;
import dagger.internal.codegen.base.RequestKinds;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.extension.Optionals;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerType;
import dagger.spi.model.Key;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;

public final class KeyFactory {
    private final XProcessingEnv processingEnv;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    KeyFactory(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, InjectionAnnotations injectionAnnotations) {
        this.processingEnv = processingEnv;
        this.types = types;
        this.elements = elements;
        this.injectionAnnotations = injectionAnnotations;
    }

    private TypeMirror boxPrimitives(TypeMirror type) {
        return type.getKind().isPrimitive() ? this.types.boxedClass((PrimitiveType)type).asType() : type;
    }

    private DeclaredType setOf(TypeMirror elementType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.SET), this.boxPrimitives(elementType));
    }

    private DeclaredType mapOf(XType keyType, XType valueType) {
        return this.mapOf(XConverters.toJavac((XType)keyType), XConverters.toJavac((XType)valueType));
    }

    private DeclaredType mapOf(TypeMirror keyType, TypeMirror valueType) {
        return this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.MAP), this.boxPrimitives(keyType), this.boxPrimitives(valueType));
    }

    private TypeMirror mapOfFrameworkType(XType keyType, ClassName frameworkClassName, XType valueType) {
        return this.mapOfFrameworkType(XConverters.toJavac((XType)keyType), frameworkClassName, XConverters.toJavac((XType)valueType));
    }

    private TypeMirror mapOfFrameworkType(TypeMirror keyType, ClassName frameworkClassName, TypeMirror valueType) {
        return this.mapOf(keyType, this.types.getDeclaredType(this.elements.getTypeElement(frameworkClassName), this.boxPrimitives(valueType)));
    }

    Key forComponentMethod(XMethodElement componentMethod) {
        return this.forMethod(componentMethod, componentMethod.getReturnType());
    }

    Key forProductionComponentMethod(XMethodElement componentMethod) {
        XType returnType = componentMethod.getReturnType();
        XType keyType = DaggerTypes.isFutureType(returnType) ? (XType)Iterables.getOnlyElement((Iterable)returnType.getTypeArguments()) : returnType;
        return this.forMethod(componentMethod, keyType);
    }

    Key forSubcomponentCreatorMethod(XMethodElement subcomponentCreatorMethod, XType declaredContainer) {
        Preconditions.checkArgument((boolean)XTypes.isDeclared((XType)declaredContainer));
        XMethodType resolvedMethod = subcomponentCreatorMethod.asMemberOf(declaredContainer);
        return Key.builder((DaggerType)DaggerType.from((XType)resolvedMethod.getReturnType())).build();
    }

    public Key forSubcomponentCreator(XType creatorType) {
        return Key.builder((DaggerType)DaggerType.from((XType)creatorType)).build();
    }

    public Key forProvidesMethod(XMethodElement method, XTypeElement contributingModule) {
        return this.forProvidesMethod(XConverters.toJavac((XExecutableElement)method), XConverters.toJavac((XTypeElement)contributingModule));
    }

    public Key forProvidesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(TypeNames.PROVIDER));
    }

    public Key forProducesMethod(XMethodElement method, XTypeElement contributingModule) {
        return this.forProducesMethod(XConverters.toJavac((XExecutableElement)method), XConverters.toJavac((XTypeElement)contributingModule));
    }

    public Key forProducesMethod(ExecutableElement method, TypeElement contributingModule) {
        return this.forBindingMethod(method, contributingModule, Optional.of(TypeNames.PRODUCER));
    }

    Key forBindsMethod(XMethodElement method, XTypeElement contributingModule) {
        return this.forBindsMethod(XConverters.toJavac((XExecutableElement)method), XConverters.toJavac((XTypeElement)contributingModule));
    }

    Key forBindsMethod(ExecutableElement method, TypeElement contributingModule) {
        Preconditions.checkArgument((boolean)DaggerElements.isAnnotationPresent((Element)method, TypeNames.BINDS));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    Key forBindsOptionalOfMethod(XMethodElement method, XTypeElement contributingModule) {
        Preconditions.checkArgument((boolean)method.hasAnnotation(TypeNames.BINDS_OPTIONAL_OF));
        return this.forBindingMethod(method, contributingModule, Optional.empty());
    }

    private Key forBindingMethod(XMethodElement method, XTypeElement contributingModule, Optional<ClassName> frameworkClassName) {
        return this.forBindingMethod(XConverters.toJavac((XExecutableElement)method), XConverters.toJavac((XTypeElement)contributingModule), frameworkClassName);
    }

    private Key forBindingMethod(ExecutableElement method, TypeElement contributingModule, Optional<ClassName> frameworkClassName) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable((TypeMirror)this.types.asMemberOf(MoreTypes.asDeclared((TypeMirror)contributingModule.asType()), method));
        ContributionType contributionType = ContributionType.fromBindingElement(method);
        TypeMirror returnType = methodType.getReturnType();
        if (frameworkClassName.isPresent() && frameworkClassName.get().equals((Object)TypeNames.PRODUCER) && MoreTypes.isType((TypeMirror)returnType)) {
            SetType setType;
            if (DaggerTypes.isFutureType(methodType.getReturnType())) {
                returnType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared((TypeMirror)returnType).getTypeArguments());
            } else if (contributionType.equals((Object)ContributionType.SET_VALUES) && SetType.isSet(returnType) && DaggerTypes.isFutureType((setType = SetType.from(XConverters.toXProcessing((TypeMirror)returnType, (XProcessingEnv)this.processingEnv))).elementType())) {
                returnType = this.types.getDeclaredType(this.elements.getTypeElement(TypeNames.SET), XConverters.toJavac((XType)DaggerTypes.unwrapType(setType.elementType())));
            }
        }
        TypeMirror keyType = this.bindingMethodKeyType(returnType, method, contributionType, frameworkClassName);
        Key key = this.forMethod(method, keyType);
        return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.toBuilder().multibindingContributionIdentifier(new Key.MultibindingContributionIdentifier(method, contributingModule)).build();
    }

    Key forMultibindsMethod(XMethodElement method, XMethodType methodType) {
        XType returnType = method.getReturnType();
        TypeMirror keyType = MapType.isMap(returnType) ? this.mapOfFrameworkType(MapType.from(returnType).keyType(), TypeNames.PROVIDER, MapType.from(returnType).valueType()) : XConverters.toJavac((XType)returnType);
        return this.forMethod(XConverters.toJavac((XExecutableElement)method), keyType);
    }

    private TypeMirror bindingMethodKeyType(TypeMirror returnType, ExecutableElement method, ContributionType contributionType, Optional<ClassName> frameworkClassName) {
        switch (contributionType) {
            case UNIQUE: {
                return returnType;
            }
            case SET: {
                return this.setOf(returnType);
            }
            case MAP: {
                TypeMirror mapKeyType = MapKeys.mapKeyType(XConverters.toXProcessing((AnnotationMirror)MapKeys.getMapKey(method).get(), (XProcessingEnv)this.processingEnv));
                return frameworkClassName.isPresent() ? this.mapOfFrameworkType(mapKeyType, frameworkClassName.get(), returnType) : this.mapOf(mapKeyType, returnType);
            }
            case SET_VALUES: {
                Preconditions.checkArgument((boolean)SetType.isSet(returnType));
                return returnType;
            }
        }
        throw new AssertionError();
    }

    Key forDelegateBinding(DelegateDeclaration delegateDeclaration, ClassName frameworkType) {
        return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
    }

    private Key forMethod(XMethodElement method, XType keyType) {
        return this.forMethod(XConverters.toJavac((XExecutableElement)method), XConverters.toJavac((XType)keyType));
    }

    private Key forMethod(ExecutableElement method, TypeMirror keyType) {
        return this.forQualifiedType(this.injectionAnnotations.getQualifier(method), keyType);
    }

    public Key forInjectConstructorWithResolvedType(XType type) {
        return this.forInjectConstructorWithResolvedType(XConverters.toJavac((XType)type));
    }

    public Key forInjectConstructorWithResolvedType(TypeMirror type) {
        return Key.builder((DaggerType)this.fromJava(type)).build();
    }

    Key forType(XType type) {
        return Key.builder((DaggerType)DaggerType.from((XType)type)).build();
    }

    public Key forMembersInjectedType(TypeMirror type) {
        return this.forMembersInjectedType(XConverters.toXProcessing((TypeMirror)type, (XProcessingEnv)this.processingEnv));
    }

    public Key forMembersInjectedType(XType type) {
        return Key.builder((DaggerType)DaggerType.from((XType)type)).build();
    }

    Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type) {
        return this.forQualifiedType(qualifier.map(annotation -> XConverters.toXProcessing((AnnotationMirror)annotation, (XProcessingEnv)this.processingEnv)), XConverters.toXProcessing((TypeMirror)type, (XProcessingEnv)this.processingEnv));
    }

    Key forQualifiedType(Optional<XAnnotation> qualifier, XType type) {
        return Key.builder((DaggerType)DaggerType.from((XType)type.boxed())).qualifier(qualifier.map(DaggerAnnotation::from)).build();
    }

    public Key forProductionExecutor() {
        return Key.builder((DaggerType)this.fromJava(this.elements.getTypeElement(TypeNames.EXECUTOR).asType())).qualifier(this.fromJava(XConverters.toJavac((XAnnotation)ProducerAnnotations.productionQualifier(this.processingEnv)))).build();
    }

    public Key forProductionImplementationExecutor() {
        return Key.builder((DaggerType)this.fromJava(this.elements.getTypeElement(TypeNames.EXECUTOR).asType())).qualifier(this.fromJava(XConverters.toJavac((XAnnotation)ProducerAnnotations.productionImplementationQualifier(this.processingEnv)))).build();
    }

    public Key forProductionComponentMonitor() {
        return Key.builder((DaggerType)this.fromJava(this.elements.getTypeElement(TypeNames.PRODUCTION_COMPONENT_MONITOR).asType())).build();
    }

    ImmutableSet<Key> implicitFrameworkMapKeys(Key requestKey) {
        return (ImmutableSet)Stream.of(this.implicitMapProviderKeyFrom(requestKey), this.implicitMapProducerKeyFrom(requestKey)).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, TypeNames.PRODUCED, TypeNames.PROVIDER), this.wrapMapKey(possibleMapKey, TypeNames.PROVIDER), (Optional[])new Optional[0]);
    }

    Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
        return Optionals.firstPresent(this.rewrapMapKey(possibleMapKey, TypeNames.PRODUCED, TypeNames.PRODUCER), this.wrapMapKey(possibleMapKey, TypeNames.PRODUCER), (Optional[])new Optional[0]);
    }

    public Key unwrapMapValueType(Key key) {
        MapType mapType;
        if (MapType.isMap(key) && !(mapType = MapType.from(key)).isRawType()) {
            for (ClassName frameworkClass : Arrays.asList(TypeNames.PROVIDER, TypeNames.PRODUCER, TypeNames.PRODUCED)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                return key.toBuilder().type(this.fromJava(this.mapOf(mapType.keyType(), mapType.unwrappedValueType(frameworkClass)))).build();
            }
        }
        return key;
    }

    private Key wrapMapValue(Key key, ClassName newWrappingClassName) {
        Preconditions.checkArgument((boolean)FrameworkTypes.isFrameworkType(this.elements.getTypeElement(newWrappingClassName).asType()));
        return this.wrapMapKey(key, newWrappingClassName).get();
    }

    public Optional<Key> rewrapMapKey(Key possibleMapKey, ClassName currentWrappingClassName, ClassName newWrappingClassName) {
        MapType mapType;
        Preconditions.checkArgument((!currentWrappingClassName.equals((Object)newWrappingClassName) ? 1 : 0) != 0);
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && mapType.valuesAreTypeOf(currentWrappingClassName)) {
            TypeElement wrappingElement = this.elements.getTypeElement(newWrappingClassName);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, XConverters.toJavac((XType)mapType.unwrappedValueType(currentWrappingClassName)));
            return Optional.of(possibleMapKey.toBuilder().type(this.fromJava(this.mapOf(XConverters.toJavac((XType)mapType.keyType()), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    private Optional<Key> wrapMapKey(Key possibleMapKey, ClassName wrappingClassName) {
        MapType mapType;
        if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).isRawType() && !mapType.valuesAreTypeOf(wrappingClassName)) {
            TypeElement wrappingElement = this.elements.getTypeElement(wrappingClassName);
            if (wrappingElement == null) {
                return Optional.empty();
            }
            DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, XConverters.toJavac((XType)mapType.valueType()));
            return Optional.of(possibleMapKey.toBuilder().type(this.fromJava(this.mapOf(XConverters.toJavac((XType)mapType.keyType()), wrappedValueType))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapSetKey(Key key, ClassName wrappingClassName) {
        SetType setType;
        if (SetType.isSet(key) && !(setType = SetType.from(key)).isRawType() && setType.elementsAreTypeOf(wrappingClassName)) {
            return Optional.of(key.toBuilder().type(this.fromJava(this.setOf(XConverters.toJavac((XType)setType.unwrappedElementType(wrappingClassName))))).build());
        }
        return Optional.empty();
    }

    Optional<Key> unwrapOptional(Key key) {
        if (!OptionalType.isOptional(key)) {
            return Optional.empty();
        }
        XType optionalValueType = OptionalType.from(key).valueType();
        return Optional.of(key.toBuilder().type(DaggerType.from((XType)RequestKinds.extractKeyType(optionalValueType))).build());
    }

    private DaggerAnnotation fromJava(AnnotationMirror annotation) {
        return DaggerAnnotation.from((XAnnotation)XConverters.toXProcessing((AnnotationMirror)annotation, (XProcessingEnv)this.processingEnv));
    }

    private DaggerType fromJava(TypeMirror typeMirror) {
        return DaggerType.from((XType)XConverters.toXProcessing((TypeMirror)typeMirror, (XProcessingEnv)this.processingEnv));
    }
}

