/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.SuperficialValidation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public final class InjectionAnnotations {
    private static final Equivalence<AnnotationMirror> EQUIVALENCE = AnnotationMirrors.equivalence();
    private final XProcessingEnv processingEnv;
    private final DaggerElements elements;
    private final KotlinMetadataUtil kotlinMetadataUtil;

    @Inject
    InjectionAnnotations(XProcessingEnv processingEnv, DaggerElements elements, KotlinMetadataUtil kotlinMetadataUtil) {
        this.processingEnv = processingEnv;
        this.elements = elements;
        this.kotlinMetadataUtil = kotlinMetadataUtil;
    }

    public Optional<XAnnotation> getQualifier(XElement element) {
        return this.getQualifier(XConverters.toJavac((XElement)element)).map(qualifier -> XConverters.toXProcessing((AnnotationMirror)qualifier, (XProcessingEnv)this.processingEnv));
    }

    public Optional<AnnotationMirror> getQualifier(Element e) {
        if (!SuperficialValidation.validateElement((Element)e)) {
            throw new TypeNotPresentException(e.toString(), null);
        }
        Preconditions.checkNotNull((Object)e);
        ImmutableCollection<? extends AnnotationMirror> qualifierAnnotations = this.getQualifiers(e);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((AnnotationMirror)qualifierAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Qualifier annotation");
    }

    public ImmutableSet<XAnnotation> getQualifiers(XElement element) {
        return (ImmutableSet)this.getQualifiers(XConverters.toJavac((XElement)element)).stream().map(qualifier -> XConverters.toXProcessing((AnnotationMirror)qualifier, (XProcessingEnv)this.processingEnv)).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableCollection<? extends AnnotationMirror> getQualifiers(Element element) {
        ImmutableSet qualifiers = AnnotationMirrors.getAnnotatedAnnotations((Element)element, Qualifier.class);
        if (element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && MoreElements.isAnnotationPresent((Element)element, Inject.class) && this.kotlinMetadataUtil.hasMetadata(element)) {
            return (ImmutableCollection)Stream.concat(qualifiers.stream(), this.getQualifiersForKotlinProperty(MoreElements.asVariable((Element)element)).stream()).map(arg_0 -> EQUIVALENCE.wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).collect(DaggerStreams.toImmutableList());
        }
        return qualifiers.asList();
    }

    public static ImmutableSet<XConstructorElement> injectedConstructors(XTypeElement type) {
        return (ImmutableSet)type.getConstructors().stream().filter(constructor -> constructor.hasAnnotation(TypeNames.INJECT)).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableSet<ExecutableElement> injectedConstructors(TypeElement type) {
        return FluentIterable.from(ElementFilter.constructorsIn(type.getEnclosedElements())).filter(constructor -> MoreElements.isAnnotationPresent((Element)constructor, Inject.class)).toSet();
    }

    private ImmutableCollection<? extends AnnotationMirror> getQualifiersForKotlinProperty(VariableElement fieldElement) {
        if (this.kotlinMetadataUtil.isMissingSyntheticPropertyForAnnotations(fieldElement)) {
            TypeElement membersInjector = this.elements.getTypeElement(SourceFiles.membersInjectorNameForType(MoreElements.asType((Element)fieldElement.getEnclosingElement())));
            if (membersInjector != null) {
                String memberInjectedFieldSignature = SourceFiles.memberInjectedFieldSignatureForVariable(fieldElement);
                return ((Optional)ElementFilter.methodsIn(membersInjector.getEnclosedElements()).stream().filter(method -> DaggerElements.getAnnotationMirror(method, TypeNames.INJECTED_FIELD_SIGNATURE).map(annotation -> MoreAnnotationValues.getStringValue(annotation, "value")).map(memberInjectedFieldSignature::equals).orElse(false)).collect(DaggerCollectors.toOptional())).map(this::getQualifiers).orElseThrow(() -> new IllegalStateException(String.format("No matching InjectedFieldSignature for %1$s. This likely means that %1$s was compiled with an older, incompatible version of Dagger. Please update all Dagger dependencies to the same version.", memberInjectedFieldSignature)));
            }
            throw new IllegalStateException("No MembersInjector found for " + fieldElement.getEnclosingElement());
        }
        return this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(fieldElement, Qualifier.class);
    }
}

