/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

public final class FrameworkTypes {
    private static final ImmutableSet<ClassName> PROVISION_TYPES = ImmutableSet.of((Object)TypeNames.PROVIDER, (Object)TypeNames.LAZY, (Object)TypeNames.MEMBERS_INJECTOR);
    private static final ImmutableSet<ClassName> PRODUCTION_TYPES = ImmutableSet.of((Object)TypeNames.PRODUCED, (Object)TypeNames.PRODUCER);

    public static boolean isProducerType(XType type) {
        return PRODUCTION_TYPES.stream().anyMatch(className -> XTypes.isTypeOf((XType)type, (ClassName)className));
    }

    public static boolean isFrameworkType(XType type) {
        return FrameworkTypes.isFrameworkType(XConverters.toJavac((XType)type));
    }

    public static boolean isFrameworkType(TypeMirror type) {
        return MoreTypes.isType((TypeMirror)type) && (FrameworkTypes.typeIsOneOf(PROVISION_TYPES, type) || FrameworkTypes.typeIsOneOf(PRODUCTION_TYPES, type));
    }

    private static boolean typeIsOneOf(Set<ClassName> classNames, TypeMirror type) {
        return classNames.stream().anyMatch(className -> DaggerTypes.isTypeOf((TypeName)className, type));
    }

    private FrameworkTypes() {
    }
}

