/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.MultibindingFactoryCreationExpression;
import dagger.spi.model.DependencyRequest;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;

final class MapFactoryCreationExpression
extends MultibindingFactoryCreationExpression {
    private final ComponentImplementation componentImplementation;
    private final BindingGraph graph;
    private final ContributionBinding binding;
    private final DaggerElements elements;

    @AssistedInject
    MapFactoryCreationExpression(@Assisted ContributionBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, BindingGraph graph, DaggerElements elements) {
        super(binding, componentImplementation, componentRequestRepresentations);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentImplementation = componentImplementation;
        this.graph = graph;
        this.elements = elements;
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.mapFactoryClassName(this.binding)});
        if (!this.useRawType()) {
            MapType mapType = MapType.from(this.binding.key().type().java());
            TypeMirror valueType = ((Optional)Stream.of(TypeNames.PROVIDER, TypeNames.PRODUCER, TypeNames.PRODUCED).filter(mapType::valuesAreTypeOf).map(mapType::unwrappedValueType).collect(DaggerCollectors.toOptional())).orElseGet(mapType::valueType);
            builder.add("<$T, $T>", new Object[]{mapType.keyType(), valueType});
        }
        builder.add("builder($L)", new Object[]{this.binding.dependencies().size()});
        for (DependencyRequest dependency : this.binding.dependencies()) {
            ContributionBinding contributionBinding = this.graph.contributionBinding(dependency.key());
            builder.add(".put($L, $L)", new Object[]{MapKeys.getMapKeyExpression(contributionBinding, this.componentImplementation.name(), this.elements), this.multibindingDependencyExpression(dependency)});
        }
        builder.add(".build()", new Object[0]);
        return builder.build();
    }

    @AssistedFactory
    static interface Factory {
        public MapFactoryCreationExpression create(ContributionBinding var1);
    }
}

