/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.BindingGraphValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.streams.jdk8.StreamsKt;

@Singleton
public final class ModuleValidator {
    private static final ImmutableSet<ClassName> SUBCOMPONENT_TYPES;
    private static final ImmutableSet<ClassName> SUBCOMPONENT_CREATOR_TYPES;
    private static final Optional<Class<?>> ANDROID_PROCESSOR;
    private static final String CONTRIBUTES_ANDROID_INJECTOR_NAME = "dagger.android.ContributesAndroidInjector";
    private static final String ANDROID_PROCESSOR_NAME = "dagger.android.processor.AndroidProcessor";
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final BindingGraphValidator bindingGraphValidator;
    private final Map<XTypeElement, ValidationReport> cache = new HashMap<XTypeElement, ValidationReport>();
    private final Set<XTypeElement> knownModules = new HashSet<XTypeElement>();
    private final XProcessingEnv processingEnv;

    @Inject
    ModuleValidator(AnyBindingMethodValidator anyBindingMethodValidator, MethodSignatureFormatter methodSignatureFormatter, ComponentDescriptorFactory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, BindingGraphValidator bindingGraphValidator, XProcessingEnv processingEnv) {
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.bindingGraphValidator = bindingGraphValidator;
        this.processingEnv = processingEnv;
    }

    public void addKnownModules(Collection<XTypeElement> modules) {
        this.knownModules.addAll(modules);
    }

    public ValidationReport validate(XTypeElement module) {
        return this.validate(module, new HashSet<XTypeElement>());
    }

    private ValidationReport validate(XTypeElement module, Set<XTypeElement> visitedModules) {
        if (visitedModules.add(module)) {
            return Util.reentrantComputeIfAbsent(this.cache, module, m -> this.validateUncached(module, visitedModules));
        }
        return ValidationReport.about(module).build();
    }

    private ValidationReport validateUncached(XTypeElement module, Set<XTypeElement> visitedModules) {
        ValidationReport.Builder builder = ValidationReport.about(module);
        ModuleKind moduleKind = ModuleKind.forAnnotatedElement(module).get();
        Optional<XType> contributesAndroidInjector = Optional.ofNullable(this.processingEnv.findTypeElement(CONTRIBUTES_ANDROID_INJECTOR_NAME)).map(XTypeElement::getType);
        List<XMethodElement> moduleMethods = module.getDeclaredMethods();
        ArrayList<XMethodElement> bindingMethods = new ArrayList<XMethodElement>();
        block0: for (XMethodElement moduleMethod : moduleMethods) {
            if (this.anyBindingMethodValidator.isBindingMethod(moduleMethod)) {
                builder.addSubreport(this.anyBindingMethodValidator.validate(moduleMethod));
                bindingMethods.add(moduleMethod);
            }
            for (XAnnotation annotation : moduleMethod.getAllAnnotations()) {
                if (ANDROID_PROCESSOR.isPresent() || !contributesAndroidInjector.isPresent() || !XTypes.areEquivalentTypes(contributesAndroidInjector.get(), annotation.getType())) continue;
                builder.addSubreport(ValidationReport.about(moduleMethod).addError(String.format("@%s was used, but %s was not found on the processor path", CONTRIBUTES_ANDROID_INJECTOR_NAME, ANDROID_PROCESSOR_NAME)).build());
                continue block0;
            }
        }
        if (((ImmutableSet)bindingMethods.stream().map(ModuleMethodKind::ofMethod).collect(DaggerStreams.toImmutableSet())).containsAll(EnumSet.of(ModuleMethodKind.ABSTRACT_DECLARATION, ModuleMethodKind.INSTANCE_BINDING))) {
            builder.addError(String.format("A @%s may not contain both non-static and abstract binding methods", moduleKind.annotation().simpleName()));
        }
        this.validateModuleVisibility(module, moduleKind, builder);
        ImmutableListMultimap bindingMethodsByName = Multimaps.index(bindingMethods, XMethodElement::getName);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, XMethodElement>)bindingMethodsByName);
        if (!module.isInterface()) {
            this.validateBindingMethodOverrides(module, builder, (ImmutableListMultimap<String, XMethodElement>)Multimaps.index(moduleMethods, XMethodElement::getName), (ImmutableListMultimap<String, XMethodElement>)bindingMethodsByName);
        }
        this.validateModifiers(module, builder);
        this.validateReferencedModules(module, moduleKind, visitedModules, builder);
        this.validateReferencedSubcomponents(module, moduleKind, builder);
        this.validateNoScopeAnnotationsOnModuleElement(module, moduleKind, builder);
        this.validateSelfCycles(module, moduleKind, builder);
        ((Optional)module.getEnclosedTypeElements().stream().filter(XTypeElement::isCompanionObject).collect(DaggerCollectors.toOptional())).ifPresent(companionModule -> this.validateCompanionModule((XTypeElement)companionModule, builder));
        if (builder.build().isClean() && this.bindingGraphValidator.shouldDoFullBindingGraphValidation(module)) {
            this.validateModuleBindings(module, builder);
        }
        return builder.build();
    }

    private void validateReferencedSubcomponents(XTypeElement subject, ModuleKind moduleKind, ValidationReport.Builder builder) {
        XAnnotation moduleAnnotation = moduleKind.getModuleAnnotation(subject);
        for (XAnnotationValue subcomponentValue : moduleAnnotation.getAsAnnotationValueList("subcomponents")) {
            XType type2 = subcomponentValue.asType();
            if (!XTypes.isDeclared(type2)) {
                builder.addError(type2 + " is not a valid subcomponent type", subject, moduleAnnotation, subcomponentValue);
                continue;
            }
            XTypeElement subcomponentElement = type2.getTypeElement();
            if (XElements.hasAnyAnnotation((XAnnotated)subcomponentElement, SUBCOMPONENT_TYPES)) {
                ModuleValidator.validateSubcomponentHasBuilder(subject, subcomponentElement, moduleAnnotation, builder);
                continue;
            }
            builder.addError(XElements.hasAnyAnnotation((XAnnotated)subcomponentElement, SUBCOMPONENT_CREATOR_TYPES) ? ModuleValidator.moduleSubcomponentsIncludesCreator(subcomponentElement) : ModuleValidator.moduleSubcomponentsIncludesNonSubcomponent(subcomponentElement), subject, moduleAnnotation, subcomponentValue);
        }
    }

    private static String moduleSubcomponentsIncludesNonSubcomponent(XTypeElement notSubcomponent) {
        return notSubcomponent.getQualifiedName() + " is not a @Subcomponent or @ProductionSubcomponent";
    }

    private static String moduleSubcomponentsIncludesCreator(XTypeElement moduleSubcomponentsAttribute) {
        XTypeElement subcomponentType = moduleSubcomponentsAttribute.getEnclosingTypeElement();
        ComponentCreatorAnnotation creatorAnnotation = (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(ComponentCreatorAnnotation.getCreatorAnnotations(moduleSubcomponentsAttribute)));
        return String.format("%s is a @%s.%s. Did you mean to use %s?", moduleSubcomponentsAttribute.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponentType).get().simpleName(), creatorAnnotation.creatorKind().typeName(), subcomponentType.getQualifiedName());
    }

    private static void validateSubcomponentHasBuilder(XTypeElement subject, XTypeElement subcomponentAttribute, XAnnotation moduleAnnotation, ValidationReport.Builder builder) {
        if (ConfigurationAnnotations.getSubcomponentCreator(subcomponentAttribute).isPresent()) {
            return;
        }
        builder.addError(ModuleValidator.moduleSubcomponentsDoesntHaveCreator(subcomponentAttribute, moduleAnnotation), subject, moduleAnnotation);
    }

    private static String moduleSubcomponentsDoesntHaveCreator(XTypeElement subcomponent, XAnnotation moduleAnnotation) {
        return String.format("%1$s doesn't have a @%2$s.Builder or @%2$s.Factory, which is required when used with @%3$s.subcomponents", subcomponent.getQualifiedName(), ComponentAnnotation.subcomponentAnnotation(subcomponent).get().simpleName(), moduleAnnotation.getName());
    }

    private void validateModifiers(XTypeElement subject, ValidationReport.Builder builder) {
        if (XTypeElements.hasTypeParameters(subject) && !subject.isAbstract()) {
            builder.addError("Modules with type parameters must be abstract", subject);
        }
    }

    private void validateMethodsWithSameName(ValidationReport.Builder builder, ListMultimap<String, XMethodElement> bindingMethodsByName) {
        bindingMethodsByName.asMap().values().stream().filter(methods -> methods.size() > 1).flatMap(Collection::stream).forEach(duplicateMethod -> builder.addError("Cannot have more than one binding method with the same name in a single module", (XElement)duplicateMethod));
    }

    private void validateReferencedModules(XTypeElement subject, ModuleKind moduleKind, Set<XTypeElement> visitedModules, ValidationReport.Builder builder) {
        XAnnotation mirror = moduleKind.getModuleAnnotation(subject);
        builder.addSubreport(this.validateReferencedModules(subject, mirror, moduleKind.legalIncludedModuleKinds(), visitedModules));
    }

    ValidationReport validateReferencedModules(XTypeElement annotatedType, XAnnotation annotation, ImmutableSet<ModuleKind> validModuleKinds, Set<XTypeElement> visitedModules) {
        ValidationReport.Builder subreport = ValidationReport.about(annotatedType);
        for (XAnnotationValue includedModule : ModuleValidator.getModules(annotation)) {
            ImmutableSet validModuleAnnotations;
            XType type2 = includedModule.asType();
            if (!XTypes.isDeclared(type2)) {
                subreport.addError(String.format("%s is not a valid module type.", type2), annotatedType, annotation, includedModule);
                continue;
            }
            XTypeElement module = type2.getTypeElement();
            if (XTypeElements.hasTypeParameters(module)) {
                subreport.addError(String.format("%s is listed as a module, but has type parameters", module.getQualifiedName()), annotatedType, annotation, includedModule);
            }
            if (!XElements.hasAnyAnnotation((XAnnotated)module, (Collection<ClassName>)(validModuleAnnotations = (ImmutableSet)validModuleKinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet())))) {
                subreport.addError(String.format("%s is listed as a module, but is not annotated with %s", module.getQualifiedName(), (validModuleAnnotations.size() > 1 ? "one of " : "") + validModuleAnnotations.stream().map(otherClass -> "@" + otherClass.simpleName()).collect(Collectors.joining(", "))), annotatedType, annotation, includedModule);
            } else if (this.knownModules.contains(module) && !this.validate(module, visitedModules).isClean()) {
                subreport.addError(String.format("%s has errors", module.getQualifiedName()), annotatedType, annotation, includedModule);
            }
            if (!module.isCompanionObject()) continue;
            subreport.addError(String.format("%s is listed as a module, but it is a companion object class. Add @Module to the enclosing class and reference that instead.", module.getQualifiedName()), annotatedType, annotation, includedModule);
        }
        return subreport.build();
    }

    private static ImmutableList<XAnnotationValue> getModules(XAnnotation annotation) {
        if (ModuleAnnotation.isModuleAnnotation(annotation)) {
            return ImmutableList.copyOf(annotation.getAsAnnotationValueList("includes"));
        }
        if (ComponentAnnotation.isComponentAnnotation(annotation)) {
            return ImmutableList.copyOf(annotation.getAsAnnotationValueList("modules"));
        }
        throw new IllegalArgumentException(String.format("unsupported annotation: %s", annotation));
    }

    private void validateBindingMethodOverrides(XTypeElement subject, ValidationReport.Builder builder, ImmutableListMultimap<String, XMethodElement> moduleMethodsByName, ImmutableListMultimap<String, XMethodElement> bindingMethodsByName) {
        XTypeElement currentClass = subject;
        XType objectType = this.processingEnv.findType((TypeName)TypeName.OBJECT);
        HashSet visitedMethods = Sets.newHashSet();
        ListMultimap allMethodsByName = MultimapBuilder.hashKeys().arrayListValues().build(moduleMethodsByName);
        while (!currentClass.getSuperType().isSameType(objectType)) {
            currentClass = currentClass.getSuperType().getTypeElement();
            List<XMethodElement> superclassMethods = currentClass.getDeclaredMethods();
            for (XMethodElement superclassMethod : superclassMethods) {
                String name2 = superclassMethod.getName();
                for (XMethodElement bindingMethod : bindingMethodsByName.get((Object)name2)) {
                    if (!visitedMethods.add(bindingMethod) || !bindingMethod.overrides(superclassMethod, subject)) continue;
                    builder.addError(String.format("Binding methods may not override another method. Overrides: %s", this.methodSignatureFormatter.format(superclassMethod)), bindingMethod);
                }
                if (this.anyBindingMethodValidator.isBindingMethod(superclassMethod)) {
                    for (XMethodElement method : allMethodsByName.get((Object)name2)) {
                        if (!visitedMethods.add(method) || !method.overrides(superclassMethod, subject)) continue;
                        builder.addError(String.format("Binding methods may not be overridden in modules. Overrides: %s", this.methodSignatureFormatter.format(superclassMethod)), method);
                    }
                }
                allMethodsByName.put((Object)superclassMethod.getName(), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(XTypeElement moduleElement, ModuleKind moduleKind, ValidationReport.Builder reportBuilder) {
        if (moduleElement.isPrivate()) {
            reportBuilder.addError("Modules cannot be private.", moduleElement);
        } else if (XTypeElements.isEffectivelyPrivate(moduleElement)) {
            reportBuilder.addError("Modules cannot be enclosed in private types.", moduleElement);
        }
        switch (XConverters.toJavac(moduleElement).getNestingKind()) {
            case ANONYMOUS: {
                throw new IllegalStateException("Can't apply @Module to an anonymous class");
            }
            case LOCAL: {
                throw new IllegalStateException("Local classes shouldn't show up in the processor");
            }
            case MEMBER: 
            case TOP_LEVEL: {
                ImmutableSet<XTypeElement> invalidVisibilityIncludes;
                if (!XTypeElements.isEffectivelyPublic(moduleElement) || (invalidVisibilityIncludes = this.getModuleIncludesWithInvalidVisibility(moduleKind.getModuleAnnotation(moduleElement))).isEmpty()) break;
                reportBuilder.addError(String.format("This module is public, but it includes non-public (or effectively non-public) modules (%s) that have non-static, non-abstract binding methods. Either reduce the visibility of this module, make the included modules public, or make all of the binding methods on the included modules abstract or static.", ModuleValidator.formatListForErrorMessage(invalidVisibilityIncludes.asList())), moduleElement);
            }
        }
    }

    private ImmutableSet<XTypeElement> getModuleIncludesWithInvalidVisibility(XAnnotation moduleAnnotation) {
        return (ImmutableSet)moduleAnnotation.getAnnotationValue("includes").asTypeList().stream().map(XType::getTypeElement).filter(include -> !XTypeElements.isEffectivelyPublic(include)).filter(this::requiresModuleInstance).collect(DaggerStreams.toImmutableSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresModuleInstance(XTypeElement module) {
        if (module.isKotlinObject()) return false;
        if (module.isCompanionObject()) return false;
        if (StreamsKt.asStream(module.getAllMethods()).filter(this.anyBindingMethodValidator::isBindingMethod).allMatch(method -> method.isAbstract() || method.isStatic())) return false;
        return true;
    }

    private void validateNoScopeAnnotationsOnModuleElement(XTypeElement module, ModuleKind moduleKind, ValidationReport.Builder report) {
        for (XAnnotation scope : XElements.getAnnotatedAnnotations(module, TypeNames.SCOPE)) {
            report.addError(String.format("@%ss cannot be scoped. Did you mean to scope a method instead?", moduleKind.annotation().simpleName()), module, scope);
        }
    }

    private void validateSelfCycles(XTypeElement module, ModuleKind moduleKind, ValidationReport.Builder builder) {
        XAnnotation moduleAnnotation = moduleKind.getModuleAnnotation(module);
        moduleAnnotation.getAsAnnotationValueList("includes").stream().filter(includedModule -> XTypes.areEquivalentTypes(module.getType(), includedModule.asType())).forEach(includedModule -> builder.addError(String.format("@%s cannot include themselves.", moduleKind.annotation().simpleName()), module, moduleAnnotation, (XAnnotationValue)includedModule));
    }

    private void validateCompanionModule(XTypeElement companionModule, ValidationReport.Builder builder) {
        ArrayList<XMethodElement> companionBindingMethods = new ArrayList<XMethodElement>();
        for (XMethodElement companionMethod : companionModule.getDeclaredMethods()) {
            if (this.anyBindingMethodValidator.isBindingMethod(companionMethod)) {
                builder.addSubreport(this.anyBindingMethodValidator.validate(companionMethod));
                companionBindingMethods.add(companionMethod);
            }
            if (!companionMethod.hasAnnotation(TypeNames.OVERRIDE)) continue;
            builder.addError("Binding method in companion object may not override another method.", companionMethod);
        }
        ImmutableListMultimap bindingMethodsByName = Multimaps.index(companionBindingMethods, XMethodElement::getName);
        this.validateMethodsWithSameName(builder, (ListMultimap<String, XMethodElement>)bindingMethodsByName);
        if (!companionBindingMethods.isEmpty() && companionModule.isPrivate()) {
            builder.addError("A Companion Module with binding methods cannot be private.", companionModule);
        }
    }

    private void validateModuleBindings(XTypeElement module, ValidationReport.Builder report) {
        BindingGraph.TopLevelBindingGraph bindingGraph = this.bindingGraphFactory.create(this.componentDescriptorFactory.moduleComponentDescriptor(module), true).topLevelBindingGraph();
        if (!this.bindingGraphValidator.isValid(bindingGraph)) {
            report.markDirty();
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }

    static {
        Class<?> clazz;
        SUBCOMPONENT_TYPES = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
        SUBCOMPONENT_CREATOR_TYPES = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT_BUILDER, (Object)TypeNames.SUBCOMPONENT_FACTORY, (Object)TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER, (Object)TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY);
        try {
            clazz = Class.forName(ANDROID_PROCESSOR_NAME, false, ModuleValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            clazz = null;
        }
        ANDROID_PROCESSOR = Optional.ofNullable(clazz);
    }

    static enum ModuleMethodKind {
        ABSTRACT_DECLARATION,
        INSTANCE_BINDING,
        STATIC_BINDING;


        static ModuleMethodKind ofMethod(XMethodElement moduleMethod) {
            if (moduleMethod.isStatic()) {
                return STATIC_BINDING;
            }
            if (moduleMethod.isAbstract()) {
                return ABSTRACT_DECLARATION;
            }
            return INSTANCE_BINDING;
        }
    }
}

