/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeKt;
import javax.inject.Inject;

final class MembersInjectionValidator {
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    MembersInjectionValidator(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    ValidationReport validateMembersInjectionRequest(XElement requestElement, XType membersInjectedType) {
        ValidationReport.Builder report = ValidationReport.about(requestElement);
        this.checkQualifiers(report, requestElement);
        this.checkMembersInjectedType(report, membersInjectedType);
        return report.build();
    }

    ValidationReport validateMembersInjectionMethod(XMethodElement method, XType membersInjectedType) {
        Preconditions.checkArgument((method.getParameters().size() == 1 ? 1 : 0) != 0, (String)"expected a method with one parameter: %s", (Object)method);
        ValidationReport.Builder report = ValidationReport.about(method);
        this.checkQualifiers(report, method);
        this.checkQualifiers(report, method.getParameters().get(0));
        this.checkMembersInjectedType(report, membersInjectedType);
        return report.build();
    }

    private void checkQualifiers(ValidationReport.Builder report, XElement element) {
        block0: {
            UnmodifiableIterator unmodifiableIterator = this.injectionAnnotations.getQualifiers(element).iterator();
            if (!unmodifiableIterator.hasNext()) break block0;
            XAnnotation qualifier = (XAnnotation)unmodifiableIterator.next();
            report.addError("Cannot inject members into qualified types", element, qualifier);
        }
    }

    private void checkMembersInjectedType(ValidationReport.Builder report, XType type2) {
        if (!XTypes.isDeclared(type2)) {
            report.addError("Cannot inject members into " + type2);
            return;
        }
        if (XTypes.isRawParameterizedType(type2)) {
            report.addError("Cannot inject members into raw type " + type2);
            return;
        }
        if (!type2.getTypeArguments().stream().allMatch(this::isResolvableTypeArgument)) {
            report.addError("Cannot inject members into types with unbounded type arguments: " + type2);
        }
    }

    private boolean isResolvableTypeArgument(XType type2) {
        return XTypes.isDeclared(type2) || XTypeKt.isArray(type2) && this.isResolvableArrayComponentType(XTypes.asArray(type2).getComponentType());
    }

    private boolean isResolvableArrayComponentType(XType type2) {
        if (XTypes.isDeclared(type2)) {
            return type2.getTypeArguments().stream().allMatch(this::isResolvableTypeArgument);
        }
        if (XTypeKt.isArray(type2)) {
            return this.isResolvableArrayComponentType(XTypes.asArray(type2).getComponentType());
        }
        return XTypes.isPrimitive(type2);
    }
}

