/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.model.Scope;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
public final class InjectValidator
implements ClearableCache {
    private final XProcessingEnv processingEnv;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;
    private final InjectionAnnotations injectionAnnotations;
    private final KotlinMetadataUtil metadataUtil;
    private final Map<XConstructorElement, ValidationReport> reports = new HashMap<XConstructorElement, ValidationReport>();

    @Inject
    InjectValidator(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, DependencyRequestValidator dependencyRequestValidator, CompilerOptions compilerOptions, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this(processingEnv, types, elements, compilerOptions, dependencyRequestValidator, Optional.empty(), injectionAnnotations, metadataUtil);
    }

    private InjectValidator(XProcessingEnv processingEnv, DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions, DependencyRequestValidator dependencyRequestValidator, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind, InjectionAnnotations injectionAnnotations, KotlinMetadataUtil metadataUtil) {
        this.processingEnv = processingEnv;
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
        this.injectionAnnotations = injectionAnnotations;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? this : new InjectValidator(this.processingEnv, this.types, this.elements, this.compilerOptions, this.dependencyRequestValidator, Optional.of(Diagnostic.Kind.ERROR), this.injectionAnnotations, this.metadataUtil);
    }

    public ValidationReport validateConstructor(XConstructorElement constructorElement) {
        return Util.reentrantComputeIfAbsent(this.reports, constructorElement, this::validateConstructorUncached);
    }

    private ValidationReport validateConstructorUncached(XConstructorElement constructorElement) {
        ValidationReport.Builder builder;
        block13: {
            ImmutableSet<Scope> scopes;
            XTypeElement enclosingElement2;
            block12: {
                ImmutableSet injectConstructors;
                builder = ValidationReport.about(constructorElement.getEnclosingElement());
                if (constructorElement.hasAnnotation(TypeNames.INJECT) && constructorElement.hasAnnotation(TypeNames.ASSISTED_INJECT)) {
                    builder.addError("Constructors cannot be annotated with both @Inject and @AssistedInject");
                }
                ClassName injectAnnotation = XElements.getAnyAnnotation((XAnnotated)constructorElement, TypeNames.INJECT, TypeNames.ASSISTED_INJECT).map(XAnnotations::getClassName).get();
                if (constructorElement.isPrivate()) {
                    builder.addError("Dagger does not support injection into private constructors", constructorElement);
                }
                for (Object qualifier : this.injectionAnnotations.getQualifiers(constructorElement)) {
                    builder.addError(String.format("@Qualifier annotations are not allowed on @%s constructors", injectAnnotation.simpleName()), constructorElement, (XAnnotation)qualifier);
                }
                String scopeErrorMsg = String.format("@Scope annotations are not allowed on @%s constructors", injectAnnotation.simpleName());
                if (injectAnnotation.equals((Object)TypeNames.INJECT)) {
                    scopeErrorMsg = scopeErrorMsg + "; annotate the class instead";
                }
                for (Scope scope : Scopes.scopesOf(constructorElement)) {
                    builder.addError(scopeErrorMsg, constructorElement, XConverters.toXProcessing(scope.scopeAnnotation().java(), this.processingEnv));
                }
                for (XExecutableParameterElement parameter : constructorElement.getParameters()) {
                    this.validateDependencyRequest(builder, parameter);
                }
                if (this.throwsCheckedExceptions(constructorElement)) {
                    builder.addItem(String.format("Dagger does not support checked exceptions on @%s constructors", injectAnnotation.simpleName()), this.privateMemberDiagnosticKind(), constructorElement);
                }
                this.checkInjectIntoPrivateClass(constructorElement, builder);
                enclosingElement2 = constructorElement.getEnclosingElement();
                if (enclosingElement2.isAbstract()) {
                    builder.addError(String.format("@%s is nonsense on the constructor of an abstract class", injectAnnotation.simpleName()), constructorElement);
                }
                if (XConverters.toJavac(enclosingElement2).getNestingKind().isNested() && !enclosingElement2.isStatic()) {
                    builder.addError(String.format("@%s constructors are invalid on inner classes. Did you mean to make the class static?", injectAnnotation.simpleName()), constructorElement);
                }
                if ((injectConstructors = ImmutableSet.builder().addAll(InjectionAnnotations.injectedConstructors(enclosingElement2)).addAll(AssistedInjectionAnnotations.assistedInjectedConstructors(enclosingElement2)).build()).size() > 1) {
                    builder.addError("Types may only contain one injected constructor", constructorElement);
                }
                scopes = Scopes.scopesOf(enclosingElement2);
                if (!injectAnnotation.equals((Object)TypeNames.ASSISTED_INJECT)) break block12;
                for (Scope scope : scopes) {
                    builder.addError("A type with an @AssistedInject-annotated constructor cannot be scoped", enclosingElement2, XConverters.toXProcessing(scope.scopeAnnotation().java(), this.processingEnv));
                }
                break block13;
            }
            if (scopes.size() <= 1) break block13;
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", enclosingElement2, XConverters.toXProcessing(scope.scopeAnnotation().java(), this.processingEnv));
            }
        }
        return builder.build();
    }

    private ValidationReport validateField(XFieldElement fieldElement) {
        ValidationReport.Builder builder = ValidationReport.about(fieldElement);
        if (fieldElement.isFinal()) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (fieldElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private fields", this.privateMemberDiagnosticKind(), fieldElement);
        }
        if (fieldElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static fields", this.staticMemberDiagnosticKind(), fieldElement);
        }
        this.validateDependencyRequest(builder, fieldElement);
        return builder.build();
    }

    private ValidationReport validateMethod(XMethodElement methodElement) {
        ValidationReport.Builder builder = ValidationReport.about(methodElement);
        if (methodElement.isAbstract()) {
            builder.addError("Methods with @Inject may not be abstract", methodElement);
        }
        if (methodElement.isPrivate()) {
            builder.addItem("Dagger does not support injection into private methods", this.privateMemberDiagnosticKind(), methodElement);
        }
        if (methodElement.isStatic()) {
            builder.addItem("Dagger does not support injection into static methods", this.staticMemberDiagnosticKind(), methodElement);
        }
        if (XMethodElements.hasTypeParameters(methodElement)) {
            builder.addError("Methods with @Inject may not declare type parameters", methodElement);
        }
        if (!methodElement.getThrownTypes().isEmpty()) {
            builder.addError("Methods with @Inject may not throw checked exceptions. Please wrap your exceptions in a RuntimeException instead.", methodElement);
        }
        for (XExecutableParameterElement parameter : methodElement.getParameters()) {
            this.validateDependencyRequest(builder, parameter);
        }
        return builder.build();
    }

    private void validateDependencyRequest(ValidationReport.Builder builder, XVariableElement parameter) {
        this.dependencyRequestValidator.validateDependencyRequest(builder, parameter, parameter.getType());
        this.dependencyRequestValidator.checkNotProducer(builder, parameter);
    }

    public ValidationReport validateMembersInjectionType(XTypeElement typeElement2) {
        ValidationReport report;
        ValidationReport report2;
        ValidationReport.Builder builder = ValidationReport.about(typeElement2);
        boolean hasInjectedMembers = false;
        for (XFieldElement field : typeElement2.getDeclaredFields()) {
            if (!field.hasAnnotation(TypeNames.INJECT)) continue;
            hasInjectedMembers = true;
            report2 = this.validateField(field);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (XMethodElement method : typeElement2.getDeclaredMethods()) {
            if (!method.hasAnnotation(TypeNames.INJECT)) continue;
            hasInjectedMembers = true;
            report2 = this.validateMethod(method);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass(typeElement2, builder);
            this.checkInjectIntoKotlinObject(typeElement2, builder);
        }
        if (typeElement2.getSuperType() != null && !(report = this.validateType(typeElement2.getSuperType().getTypeElement())).isClean()) {
            builder.addSubreport(report);
        }
        return builder.build();
    }

    public ValidationReport validateType(XTypeElement typeElement2) {
        ValidationReport.Builder builder = ValidationReport.about(typeElement2);
        ValidationReport membersInjectionReport = this.validateMembersInjectionType(typeElement2);
        if (!membersInjectionReport.isClean()) {
            builder.addSubreport(membersInjectionReport);
        }
        Stream.concat(InjectionAnnotations.injectedConstructors(typeElement2).stream(), AssistedInjectionAnnotations.assistedInjectedConstructors(typeElement2).stream()).map(this::validateConstructor).filter(report -> !report.isClean()).forEach(builder::addSubreport);
        return builder.build();
    }

    private boolean throwsCheckedExceptions(XConstructorElement constructorElement) {
        XType runtimeException = this.processingEnv.findType((TypeName)TypeNames.RUNTIME_EXCEPTION);
        XType error = this.processingEnv.findType((TypeName)TypeNames.ERROR);
        return !constructorElement.getThrownTypes().stream().allMatch(type2 -> this.types.isSubtype((XType)type2, runtimeException) || this.types.isSubtype((XType)type2, error));
    }

    private void checkInjectIntoPrivateClass(XElement element, ValidationReport.Builder builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage(DaggerElements.closestEnclosingTypeElement(XConverters.toJavac(element)))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateMemberDiagnosticKind(), element);
        }
    }

    private void checkInjectIntoKotlinObject(XTypeElement element, ValidationReport.Builder builder) {
        if (element.isKotlinObject() || element.isCompanionObject()) {
            builder.addError("Dagger does not support injection into Kotlin objects", element);
        }
    }

    private Diagnostic.Kind privateMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind());
    }

    private Diagnostic.Kind staticMemberDiagnosticKind() {
        return this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind());
    }
}

