/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.DaggerTypeElement;
import dagger.spi.model.DiagnosticReporter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.tools.Diagnostic;

final class SubcomponentFactoryMethodValidator
implements BindingGraphPlugin {
    private final XProcessingEnv processingEnv;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;
    private final Map<BindingGraph.ComponentNode, Set<XTypeElement>> inheritedModulesCache = new HashMap<BindingGraph.ComponentNode, Set<XTypeElement>>();

    @Inject
    SubcomponentFactoryMethodValidator(XProcessingEnv processingEnv, DaggerTypes types, KotlinMetadataUtil metadataUtil) {
        this.processingEnv = processingEnv;
        this.types = types;
        this.metadataUtil = metadataUtil;
    }

    public String pluginName() {
        return "Dagger/SubcomponentFactoryMethodMissingModule";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!bindingGraph.rootComponentNode().isRealComponent() || bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        bindingGraph.network().edges().stream().flatMap(DaggerStreams.instancesOf(BindingGraph.ChildFactoryMethodEdge.class)).forEach(edge -> {
            ImmutableSet<XTypeElement> missingModules = this.findMissingModules((BindingGraph.ChildFactoryMethodEdge)edge, bindingGraph);
            if (!missingModules.isEmpty()) {
                this.reportMissingModuleParameters((BindingGraph.ChildFactoryMethodEdge)edge, missingModules, bindingGraph, diagnosticReporter);
            }
        });
    }

    private ImmutableSet<XTypeElement> findMissingModules(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph graph) {
        ImmutableSet<XTypeElement> factoryMethodParameters = this.subgraphFactoryMethodParameters(edge, graph);
        BindingGraph.ComponentNode child = (BindingGraph.ComponentNode)graph.network().incidentNodes((Object)edge).target();
        Sets.SetView<XTypeElement> modulesOwnedByChild = this.ownedModules(child, graph);
        return (ImmutableSet)graph.bindings().stream().filter(binding -> binding.componentPath().equals((Object)child.componentPath())).filter(binding -> binding.requiresModuleInstance()).map(binding -> XConverters.toXProcessing(((DaggerTypeElement)binding.contributingModule().get()).java(), this.processingEnv)).distinct().filter(module -> modulesOwnedByChild.contains(module)).filter(module -> !factoryMethodParameters.contains(module)).filter(moduleType -> !ComponentRequirement.componentCanMakeNewInstances(moduleType, this.metadataUtil)).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableSet<XTypeElement> subgraphFactoryMethodParameters(BindingGraph.ChildFactoryMethodEdge edge, BindingGraph bindingGraph) {
        BindingGraph.ComponentNode parent = (BindingGraph.ComponentNode)bindingGraph.network().incidentNodes((Object)edge).source();
        DeclaredType parentType = MoreTypes.asDeclared(parent.componentPath().currentComponent().java().asType());
        ExecutableType factoryMethodType = MoreTypes.asExecutable(this.types.asMemberOf(parentType, edge.factoryMethod().java()));
        return (ImmutableSet)MoreTypes.asTypeElements(factoryMethodType.getParameterTypes()).stream().map(typeElement2 -> XConverters.toXProcessing(typeElement2, this.processingEnv)).collect(DaggerStreams.toImmutableSet());
    }

    private Sets.SetView<XTypeElement> ownedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Sets.difference(((ComponentNodeImpl)component).componentDescriptor().moduleTypes(), this.inheritedModules(component, graph));
    }

    private Set<XTypeElement> inheritedModules(BindingGraph.ComponentNode component, BindingGraph graph) {
        return Util.reentrantComputeIfAbsent(this.inheritedModulesCache, component, this.uncachedInheritedModules(graph));
    }

    private Function<BindingGraph.ComponentNode, Set<XTypeElement>> uncachedInheritedModules(BindingGraph graph) {
        return componentNode -> componentNode.componentPath().atRoot() ? ImmutableSet.of() : (Set)graph.componentNode(componentNode.componentPath().parent()).map(parent -> Sets.union(this.ownedModules((BindingGraph.ComponentNode)parent, graph), this.inheritedModules((BindingGraph.ComponentNode)parent, graph))).get();
    }

    private void reportMissingModuleParameters(BindingGraph.ChildFactoryMethodEdge edge, ImmutableSet<XTypeElement> missingModules, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        diagnosticReporter.reportSubcomponentFactoryMethod(Diagnostic.Kind.ERROR, edge, "%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", (Object)((BindingGraph.Node)graph.network().incidentNodes((Object)edge).target()).componentPath().currentComponent().className().canonicalName(), new Object[]{Joiner.on((String)", ").join(missingModules)});
    }
}

