/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.AutoValue_ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XType;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class ComponentAnnotation {
    private static final ImmutableSet<ClassName> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT, (Object)TypeNames.PRODUCTION_COMPONENT);
    private static final ImmutableSet<ClassName> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
    private static final ImmutableSet<ClassName> CREATOR_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT_BUILDER, (Object)TypeNames.COMPONENT_FACTORY, (Object)TypeNames.PRODUCTION_COMPONENT_BUILDER, (Object)TypeNames.PRODUCTION_COMPONENT_FACTORY, (Object)TypeNames.SUBCOMPONENT_BUILDER, (Object)TypeNames.SUBCOMPONENT_FACTORY, (Object[])new ClassName[]{TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER, TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY});
    private static final ImmutableSet<ClassName> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> ALL_COMPONENT_AND_CREATOR_ANNOTATIONS = ImmutableSet.builder().addAll(ALL_COMPONENT_ANNOTATIONS).addAll(CREATOR_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> PRODUCTION_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.PRODUCTION_COMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT, (Object)TypeNames.PRODUCER_MODULE);
    private XAnnotation annotation;

    public final XAnnotation annotation() {
        return this.annotation;
    }

    public abstract ClassName className();

    public final String simpleName() {
        return this.className().simpleName();
    }

    public final boolean isSubcomponent() {
        return SUBCOMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isProduction() {
        return PRODUCTION_ANNOTATIONS.contains((Object)this.className());
    }

    public final boolean isRealComponent() {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public ImmutableList<XType> dependencyTypes() {
        return this.isRootComponent() ? ImmutableList.copyOf(this.annotation.getAsTypeList("dependencies")) : ImmutableList.of();
    }

    public ImmutableSet<XTypeElement> dependencies() {
        return (ImmutableSet)this.dependencyTypes().stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<XTypeElement> modules() {
        return (ImmutableSet)this.annotation.getAsTypeList(this.isRealComponent() ? "modules" : "includes").stream().map(XType::getTypeElement).collect(DaggerStreams.toImmutableSet());
    }

    private final boolean isRootComponent() {
        return ROOT_COMPONENT_ANNOTATIONS.contains((Object)this.className());
    }

    public static Optional<ComponentAnnotation> rootComponentAnnotation(XTypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, ROOT_COMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(XTypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, SUBCOMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element) {
        return ComponentAnnotation.anyComponentAnnotation(element, ALL_COMPONENT_ANNOTATIONS);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(XElement element, Collection<ClassName> annotations2) {
        return XElements.getAnyAnnotation((XAnnotated)element, annotations2).map(ComponentAnnotation::componentAnnotation);
    }

    public static boolean isComponentAnnotation(XAnnotation annotation) {
        return ALL_COMPONENT_ANNOTATIONS.contains((Object)XAnnotations.getClassName(annotation));
    }

    public static ComponentAnnotation componentAnnotation(XAnnotation annotation) {
        Preconditions.checkState((boolean)ComponentAnnotation.isComponentAnnotation(annotation), (Object)(annotation + " must be a Component, Subcomponent, ProductionComponent, or ProductionSubcomponent annotation"));
        return ComponentAnnotation.create(annotation);
    }

    public static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return ComponentAnnotation.create(moduleAnnotation.annotation());
    }

    private static ComponentAnnotation create(XAnnotation annotation) {
        AutoValue_ComponentAnnotation componentAnnotation = new AutoValue_ComponentAnnotation(XAnnotations.getClassName(annotation));
        componentAnnotation.annotation = annotation;
        return componentAnnotation;
    }

    public static ImmutableSet<ClassName> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAndCreatorAnnotations() {
        return ALL_COMPONENT_AND_CREATOR_ANNOTATIONS;
    }
}

