/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.AssistedInjectionParameters;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MethodRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.BindingKind;
import dagger.spi.model.RequestKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class AssistedPrivateMethodRequestRepresentation
extends MethodRequestRepresentation {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ContributionBinding binding;
    private final BindingRequest request;
    private final RequestRepresentation wrappedRequestRepresentation;
    private final CompilerOptions compilerOptions;
    private final DaggerTypes types;
    private String methodName;

    @AssistedInject
    AssistedPrivateMethodRequestRepresentation(@Assisted BindingRequest request, @Assisted ContributionBinding binding, @Assisted RequestRepresentation wrappedRequestRepresentation, ComponentImplementation componentImplementation, DaggerTypes types, CompilerOptions compilerOptions) {
        super(componentImplementation.shardImplementation(binding), types);
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        Preconditions.checkArgument((request.requestKind() == RequestKind.INSTANCE ? 1 : 0) != 0);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.request = (BindingRequest)Preconditions.checkNotNull((Object)request);
        this.wrappedRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)wrappedRequestRepresentation);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.compilerOptions = compilerOptions;
        this.types = types;
    }

    Expression getAssistedDependencyExpression(ClassName requestingClass) {
        return Expression.create(this.returnType(), requestingClass.equals((Object)this.shardImplementation.name()) ? CodeBlock.of((String)"$N($L)", (Object[])new Object[]{this.methodName(), CodeBlocks.parameterNames(AssistedInjectionAnnotations.assistedParameterSpecs(this.binding, this.types))}) : CodeBlock.of((String)"$L.$N($L)", (Object[])new Object[]{this.shardImplementation.shardFieldReference(), this.methodName(), CodeBlocks.parameterNames(AssistedInjectionAnnotations.assistedParameterSpecs(this.binding, this.types))}));
    }

    @Override
    protected CodeBlock methodCall() {
        throw new IllegalStateException("This should not be accessed");
    }

    @Override
    protected TypeMirror returnType() {
        return this.types.accessibleType(this.binding.contributedType(), this.shardImplementation.name());
    }

    private String methodName() {
        if (this.methodName == null) {
            this.methodName = this.shardImplementation.getUniqueMethodName(this.request);
            this.shardImplementation.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)this.methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(AssistedInjectionParameters.assistedParameterSpecs(this.binding, this.types, this.shardImplementation)).returns(TypeName.get((TypeMirror)this.returnType())).addStatement("return $L", new Object[]{this.wrappedRequestRepresentation.getDependencyExpression(this.shardImplementation.name()).codeBlock()}).build());
        }
        return this.methodName;
    }

    @AssistedFactory
    static interface Factory {
        public AssistedPrivateMethodRequestRepresentation create(BindingRequest var1, ContributionBinding var2, RequestRepresentation var3);
    }
}

