/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.BindingKind;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

final class AssistedInjectionParameters {
    public static ImmutableList<ParameterSpec> assistedParameterSpecs(Binding binding, DaggerTypes types, ComponentImplementation.ShardImplementation shardImplementation) {
        Preconditions.checkArgument((binding.kind() == BindingKind.ASSISTED_INJECTION ? 1 : 0) != 0);
        ExecutableElement constructor = MoreElements.asExecutable(binding.bindingElement().get());
        ExecutableType constructorType = MoreTypes.asExecutable(types.asMemberOf(MoreTypes.asDeclared(binding.key().type().java()), constructor));
        return AssistedInjectionParameters.assistedParameterSpecs(constructor.getParameters(), constructorType.getParameterTypes(), shardImplementation);
    }

    private static ImmutableList<ParameterSpec> assistedParameterSpecs(List<? extends VariableElement> paramElements, List<? extends TypeMirror> paramTypes, ComponentImplementation.ShardImplementation shardImplementation) {
        ImmutableList.Builder assistedParameterSpecs = ImmutableList.builder();
        for (int i = 0; i < paramElements.size(); ++i) {
            VariableElement paramElement = paramElements.get(i);
            TypeMirror paramType = paramTypes.get(i);
            if (!AssistedInjectionAnnotations.isAssistedParameter(paramElement)) continue;
            assistedParameterSpecs.add((Object)ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)paramType), (String)shardImplementation.getUniqueFieldNameForAssistedParam(paramElement), (Modifier[])new Modifier[0]).build());
        }
        return assistedParameterSpecs.build();
    }

    private AssistedInjectionParameters() {
    }
}

