/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import javax.inject.Inject;
import javax.tools.Diagnostic;

public final class MultibindingAnnotationsProcessingStep
extends TypeCheckingProcessingStep<XExecutableElement> {
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final XMessager messager;

    @Inject
    MultibindingAnnotationsProcessingStep(AnyBindingMethodValidator anyBindingMethodValidator, XMessager messager2) {
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.messager = messager2;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.INTO_SET, (Object)TypeNames.ELEMENTS_INTO_SET, (Object)TypeNames.INTO_MAP);
    }

    @Override
    protected void process(XExecutableElement method, ImmutableSet<ClassName> annotations2) {
        if (!this.anyBindingMethodValidator.isBindingMethod(method)) {
            annotations2.forEach(annotation -> this.messager.printMessage(Diagnostic.Kind.ERROR, "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods", method, method.getAnnotation((ClassName)annotation)));
        }
    }
}

