/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class MembersInjectionValidator {
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    MembersInjectionValidator(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    ValidationReport validateMembersInjectionRequest(Element requestElement, TypeMirror membersInjectedType) {
        ValidationReport.Builder report = ValidationReport.about(requestElement);
        this.checkQualifiers(report, requestElement);
        this.checkMembersInjectedType(report, membersInjectedType);
        return report.build();
    }

    ValidationReport validateMembersInjectionMethod(ExecutableElement method, TypeMirror membersInjectedType) {
        Preconditions.checkArgument((method.getParameters().size() == 1 ? 1 : 0) != 0, (String)"expected a method with one parameter: %s", (Object)method);
        ValidationReport.Builder report = ValidationReport.about(method);
        this.checkQualifiers(report, method);
        this.checkQualifiers(report, method.getParameters().get(0));
        this.checkMembersInjectedType(report, membersInjectedType);
        return report.build();
    }

    private void checkQualifiers(ValidationReport.Builder report, Element element) {
        block0: {
            UnmodifiableIterator unmodifiableIterator = this.injectionAnnotations.getQualifiers(element).iterator();
            if (!unmodifiableIterator.hasNext()) break block0;
            AnnotationMirror qualifier = (AnnotationMirror)unmodifiableIterator.next();
            report.addError("Cannot inject members into qualified types", element, qualifier);
        }
    }

    private void checkMembersInjectedType(ValidationReport.Builder report, TypeMirror type2) {
        if (type2.getKind() != TypeKind.DECLARED) {
            report.addError("Cannot inject members into " + type2);
            return;
        }
        ImmutableList typeArguments2 = ImmutableList.copyOf(MoreTypes.asDeclared(type2).getTypeArguments());
        ImmutableList typeParameters = ImmutableList.copyOf(MoreTypes.asTypeElement(type2).getTypeParameters());
        if (typeArguments2.isEmpty() && !typeParameters.isEmpty()) {
            report.addError("Cannot inject members into raw type " + type2);
            return;
        }
        if (!typeArguments2.stream().allMatch(this::isResolvableTypeArgument)) {
            report.addError("Cannot inject members into types with unbounded type arguments: " + type2);
        }
    }

    private boolean isResolvableTypeArgument(TypeMirror typeArgument) {
        switch (typeArgument.getKind()) {
            case DECLARED: {
                return true;
            }
            case ARRAY: {
                return this.isResolvableArrayComponentType(MoreTypes.asArray(typeArgument).getComponentType());
            }
        }
        return false;
    }

    private boolean isResolvableArrayComponentType(TypeMirror componentType2) {
        switch (componentType2.getKind()) {
            case DECLARED: {
                return MoreTypes.asDeclared(componentType2).getTypeArguments().stream().allMatch(this::isResolvableTypeArgument);
            }
            case ARRAY: {
                return this.isResolvableArrayComponentType(MoreTypes.asArray(componentType2).getComponentType());
            }
        }
        return componentType2.getKind().isPrimitive();
    }
}

