/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindsInstanceElementValidator;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class BindsInstanceMethodValidator
extends BindsInstanceElementValidator<XExecutableElement> {
    @Inject
    BindsInstanceMethodValidator(InjectionAnnotations injectionAnnotations) {
        super(injectionAnnotations);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XExecutableElement xElement) {
        return new Validator(xElement);
    }

    private static String didYouMeanBinds(ModuleAnnotation moduleAnnotation) {
        return String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", moduleAnnotation.annotationName());
    }

    private class Validator
    extends BindingElementValidator.ElementValidator {
        Validator(XExecutableElement xElement) {
            super((BindingElementValidator)BindsInstanceMethodValidator.this, (XElement)xElement);
        }

        @Override
        protected void checkAdditionalProperties() {
            if (!((XExecutableElement)this.xElement).isAbstract()) {
                this.report.addError("@BindsInstance methods must be abstract");
            }
            if (((XExecutableElement)this.xElement).getParameters().size() != 1) {
                this.report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
            }
            TypeElement enclosingType = MoreElements.asType(this.element.getEnclosingElement());
            ModuleAnnotation.moduleAnnotation(enclosingType).ifPresent(moduleAnnotation -> this.report.addError(BindsInstanceMethodValidator.didYouMeanBinds(moduleAnnotation)));
            ComponentAnnotation.anyComponentAnnotation(enclosingType).ifPresent(componentAnnotation -> this.report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", componentAnnotation.simpleName())));
        }

        @Override
        protected Optional<TypeMirror> bindingElementType() {
            List<XExecutableParameterElement> parameters2 = ((XExecutableElement)this.xElement).getParameters();
            return parameters2.size() == 1 ? Optional.of(XConverters.toJavac(((XVariableElement)Iterables.getOnlyElement(parameters2)).getType())) : Optional.empty();
        }
    }
}

