/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.;
import dagger.internal.codegen.base.AutoValue_ComponentAnnotation_FictionalComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.MoreAnnotationMirrors;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class ComponentAnnotation {
    private static final ImmutableSet<ClassName> ROOT_COMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT, (Object)TypeNames.PRODUCTION_COMPONENT);
    private static final ImmutableSet<ClassName> SUBCOMPONENT_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.SUBCOMPONENT, (Object)TypeNames.PRODUCTION_SUBCOMPONENT);
    private static final ImmutableSet<ClassName> CREATOR_ANNOTATIONS = ImmutableSet.of((Object)TypeNames.COMPONENT_BUILDER, (Object)TypeNames.COMPONENT_FACTORY, (Object)TypeNames.PRODUCTION_COMPONENT_BUILDER, (Object)TypeNames.PRODUCTION_COMPONENT_FACTORY, (Object)TypeNames.SUBCOMPONENT_BUILDER, (Object)TypeNames.SUBCOMPONENT_FACTORY, (Object[])new ClassName[]{TypeNames.PRODUCTION_SUBCOMPONENT_BUILDER, TypeNames.PRODUCTION_SUBCOMPONENT_FACTORY});
    private static final ImmutableSet<ClassName> ALL_COMPONENT_ANNOTATIONS = ImmutableSet.builder().addAll(ROOT_COMPONENT_ANNOTATIONS).addAll(SUBCOMPONENT_ANNOTATIONS).build();
    private static final ImmutableSet<ClassName> ALL_COMPONENT_AND_CREATOR_ANNOTATIONS = ImmutableSet.builder().addAll(ALL_COMPONENT_ANNOTATIONS).addAll(CREATOR_ANNOTATIONS).build();

    public abstract AnnotationMirror annotation();

    public String simpleName() {
        return MoreAnnotationMirrors.simpleName(this.annotation()).toString();
    }

    public abstract boolean isSubcomponent();

    public abstract boolean isProduction();

    public abstract boolean isRealComponent();

    public abstract ImmutableList<AnnotationValue> dependencyValues();

    public ImmutableList<TypeMirror> dependencyTypes() {
        return (ImmutableList)this.dependencyValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<TypeElement> dependencies() {
        return MoreTypes.asTypeElements(this.dependencyTypes()).asList();
    }

    public abstract ImmutableList<AnnotationValue> moduleValues();

    public ImmutableList<TypeMirror> moduleTypes() {
        return (ImmutableList)this.moduleValues().stream().map(MoreAnnotationValues::asType).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableSet<TypeElement> modules() {
        return MoreTypes.asTypeElements(this.moduleTypes());
    }

    protected final ImmutableList<AnnotationValue> getAnnotationValues(String parameterName) {
        return MoreAnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(this.annotation(), parameterName));
    }

    public static Optional<ComponentAnnotation> rootComponentAnnotation(TypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, ROOT_COMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> subcomponentAnnotation(TypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, SUBCOMPONENT_ANNOTATIONS);
    }

    public static Optional<ComponentAnnotation> anyComponentAnnotation(TypeElement typeElement2) {
        return ComponentAnnotation.anyComponentAnnotation(typeElement2, ALL_COMPONENT_ANNOTATIONS);
    }

    private static Optional<ComponentAnnotation> anyComponentAnnotation(TypeElement typeElement2, Collection<ClassName> annotations2) {
        return DaggerElements.getAnyAnnotation(typeElement2, annotations2).map(ComponentAnnotation::componentAnnotation);
    }

    public static boolean isComponentAnnotation(AnnotationMirror annotation) {
        return ALL_COMPONENT_ANNOTATIONS.stream().anyMatch(annotationClass -> DaggerTypes.isTypeOf((TypeName)annotationClass, annotation.getAnnotationType()));
    }

    public static ComponentAnnotation componentAnnotation(AnnotationMirror annotation) {
        RealComponentAnnotation.Builder annotationBuilder = RealComponentAnnotation.builder().annotation(annotation);
        if (DaggerTypes.isTypeOf((TypeName)TypeNames.COMPONENT, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(false).isSubcomponent(false).build();
        }
        if (DaggerTypes.isTypeOf((TypeName)TypeNames.SUBCOMPONENT, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(false).isSubcomponent(true).build();
        }
        if (DaggerTypes.isTypeOf((TypeName)TypeNames.PRODUCTION_COMPONENT, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(true).isSubcomponent(false).build();
        }
        if (DaggerTypes.isTypeOf((TypeName)TypeNames.PRODUCTION_SUBCOMPONENT, annotation.getAnnotationType())) {
            return annotationBuilder.isProduction(true).isSubcomponent(true).build();
        }
        throw new IllegalArgumentException(annotation + " must be a Component, Subcomponent, ProductionComponent, or ProductionSubcomponent annotation");
    }

    public static ComponentAnnotation fromModuleAnnotation(ModuleAnnotation moduleAnnotation) {
        return new AutoValue_ComponentAnnotation_FictionalComponentAnnotation(moduleAnnotation);
    }

    public static ImmutableSet<ClassName> rootComponentAnnotations() {
        return ROOT_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> subcomponentAnnotations() {
        return SUBCOMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAnnotations() {
        return ALL_COMPONENT_ANNOTATIONS;
    }

    public static ImmutableSet<ClassName> allComponentAndCreatorAnnotations() {
        return ALL_COMPONENT_AND_CREATOR_ANNOTATIONS;
    }

    @AutoValue
    static abstract class FictionalComponentAnnotation
    extends ComponentAnnotation {
        FictionalComponentAnnotation() {
        }

        @Override
        public AnnotationMirror annotation() {
            return this.moduleAnnotation().annotation();
        }

        @Override
        public boolean isSubcomponent() {
            return false;
        }

        @Override
        public boolean isProduction() {
            return ClassName.get((TypeElement)MoreElements.asType(this.moduleAnnotation().annotation().getAnnotationType().asElement())).equals((Object)TypeNames.PRODUCER_MODULE);
        }

        @Override
        public boolean isRealComponent() {
            return false;
        }

        @Override
        public ImmutableList<AnnotationValue> dependencyValues() {
            return ImmutableList.of();
        }

        @Override
        public ImmutableList<AnnotationValue> moduleValues() {
            return this.moduleAnnotation().includesAsAnnotationValues();
        }

        @Override
        public ImmutableList<TypeMirror> moduleTypes() {
            return super.moduleTypes();
        }

        @Override
        public ImmutableSet<TypeElement> modules() {
            return super.modules();
        }

        public abstract ModuleAnnotation moduleAnnotation();
    }

    @AutoValue
    static abstract class RealComponentAnnotation
    extends ComponentAnnotation {
        RealComponentAnnotation() {
        }

        @Override
        public ImmutableList<AnnotationValue> dependencyValues() {
            return this.isSubcomponent() ? ImmutableList.of() : this.getAnnotationValues("dependencies");
        }

        @Override
        public ImmutableList<TypeMirror> dependencyTypes() {
            return super.dependencyTypes();
        }

        @Override
        public ImmutableList<TypeElement> dependencies() {
            return super.dependencies();
        }

        @Override
        public boolean isRealComponent() {
            return true;
        }

        @Override
        public ImmutableList<AnnotationValue> moduleValues() {
            return this.getAnnotationValues("modules");
        }

        @Override
        public ImmutableList<TypeMirror> moduleTypes() {
            return super.moduleTypes();
        }

        @Override
        public ImmutableSet<TypeElement> modules() {
            return super.modules();
        }

        static Builder builder() {
            return new .AutoValue_ComponentAnnotation_RealComponentAnnotation.Builder();
        }

        @AutoValue.Builder
        static interface Builder {
            public Builder annotation(AnnotationMirror var1);

            public Builder isSubcomponent(boolean var1);

            public Builder isProduction(boolean var1);

            public RealComponentAnnotation build();
        }
    }
}

