/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.spi.model.Key;
import dagger.spi.model.RequestKind;
import javax.lang.model.SourceVersion;

final class ImmediateFutureBindingExpression
extends BindingExpression {
    private final Key key;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final SourceVersion sourceVersion;

    @AssistedInject
    ImmediateFutureBindingExpression(@Assisted Key key, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, SourceVersion sourceVersion) {
        this.key = key;
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.sourceVersion = (SourceVersion)((Object)Preconditions.checkNotNull((Object)((Object)sourceVersion)));
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return Expression.create(this.types.wrapType(this.key.type().java(), ListenableFuture.class), CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.instanceExpression(requestingClass)}));
    }

    private CodeBlock instanceExpression(ClassName requestingClass) {
        Expression expression = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(this.key, RequestKind.INSTANCE), requestingClass);
        if (this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 && !this.types.isSameType(expression.type(), this.key.type().java())) {
            return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{this.types.accessibleType(this.key.type().java(), requestingClass), expression.codeBlock()});
        }
        return expression.codeBlock();
    }

    @AssistedFactory
    static interface Factory {
        public ImmediateFutureBindingExpression create(Key var1);
    }
}

