/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.validation.ExternalBindingGraphPlugins;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugins;
import dagger.spi.model.BindingGraph;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.TypeElement;

@Singleton
public final class BindingGraphValidator {
    private final ValidationBindingGraphPlugins validationPlugins;
    private final ExternalBindingGraphPlugins externalPlugins;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphValidator(ValidationBindingGraphPlugins validationPlugins, ExternalBindingGraphPlugins externalPlugins, CompilerOptions compilerOptions) {
        this.validationPlugins = validationPlugins;
        this.externalPlugins = externalPlugins;
        this.compilerOptions = compilerOptions;
    }

    public boolean shouldDoFullBindingGraphValidation(TypeElement component) {
        return this.requiresFullBindingGraphValidation() || this.compilerOptions.pluginsVisitFullBindingGraphs(component);
    }

    private boolean requiresFullBindingGraphValidation() {
        return !this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.NONE);
    }

    public boolean isValid(BindingGraph graph) {
        return this.visitValidationPlugins(graph) && this.visitExternalPlugins(graph);
    }

    private boolean visitValidationPlugins(BindingGraph graph) {
        if (graph.isFullBindingGraph() && !this.requiresFullBindingGraphValidation()) {
            return true;
        }
        return this.validationPlugins.visit(graph);
    }

    private boolean visitExternalPlugins(BindingGraph graph) {
        TypeElement component = graph.rootComponentNode().componentPath().currentComponent().java();
        if (graph.isFullBindingGraph() && !this.requiresFullBindingGraphValidation() && !this.compilerOptions.pluginsVisitFullBindingGraphs(component)) {
            return true;
        }
        return this.externalPlugins.visit(graph);
    }
}

