/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.Scope;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ComponentDescriptorFactory {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final ModuleDescriptor.Factory moduleDescriptorFactory;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    ComponentDescriptorFactory(DaggerElements elements, DaggerTypes types, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory, InjectionAnnotations injectionAnnotations) {
        this.elements = elements;
        this.types = types;
        this.dependencyRequestFactory = dependencyRequestFactory;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.injectionAnnotations = injectionAnnotations;
    }

    public ComponentDescriptor rootComponentDescriptor(TypeElement typeElement2) {
        return this.create(typeElement2, (ComponentAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement2, ComponentAnnotation::rootComponentAnnotation, "must have a component annotation"));
    }

    public ComponentDescriptor subcomponentDescriptor(TypeElement typeElement2) {
        return this.create(typeElement2, (ComponentAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement2, ComponentAnnotation::subcomponentAnnotation, "must have a subcomponent annotation"));
    }

    public ComponentDescriptor moduleComponentDescriptor(TypeElement typeElement2) {
        return this.create(typeElement2, ComponentAnnotation.fromModuleAnnotation((ModuleAnnotation)ComponentDescriptorFactory.checkAnnotation(typeElement2, ModuleAnnotation::moduleAnnotation, "must have a module annotation")));
    }

    private static <A> A checkAnnotation(TypeElement typeElement2, Function<TypeElement, Optional<A>> annotationFunction, String message) {
        return annotationFunction.apply(typeElement2).orElseThrow(() -> new IllegalArgumentException(typeElement2 + " " + message));
    }

    private ComponentDescriptor create(TypeElement typeElement2, ComponentAnnotation componentAnnotation) {
        ImmutableSet enclosedCreators;
        ImmutableSet componentDependencies = (ImmutableSet)componentAnnotation.dependencyTypes().stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet());
        ImmutableMap.Builder dependenciesByDependencyMethod = ImmutableMap.builder();
        for (ComponentRequirement componentDependency : componentDependencies) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency.typeElement()))) {
                if (!ComponentDescriptor.isComponentContributionMethod(this.elements, executableElement)) continue;
                dependenciesByDependencyMethod.put((Object)executableElement, (Object)componentDependency);
            }
        }
        ImmutableSet modules = componentAnnotation.isRealComponent() ? componentAnnotation.modules() : ImmutableSet.of((Object)typeElement2);
        ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Iterable<TypeElement>)modules);
        ImmutableSet.Builder subcomponentsFromModules = ImmutableSet.builder();
        for (ModuleDescriptor module : transitiveModules) {
            for (SubcomponentDeclaration subcomponentDeclaration : module.subcomponentDeclarations()) {
                TypeElement subcomponent2 = subcomponentDeclaration.subcomponentType();
                subcomponentsFromModules.add((Object)this.subcomponentDescriptor(subcomponent2));
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
        ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
        if (componentAnnotation.isRealComponent()) {
            ImmutableSet<ExecutableElement> unimplementedMethods = this.elements.getUnimplementedMethods(typeElement2);
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ComponentDescriptor.ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(typeElement2, componentAnnotation, componentMethod);
                builder.add((Object)componentMethodDescriptor);
                componentMethodDescriptor.subcomponent().ifPresent(subcomponent -> {
                    if (componentMethodDescriptor.dependencyRequest().isPresent()) {
                        subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, subcomponent);
                    } else {
                        subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, subcomponent);
                    }
                });
            }
        }
        Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = (ImmutableSet)ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation).stream().flatMap(creatorAnnotation -> ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement2, creatorAnnotation).stream()).collect(DaggerStreams.toImmutableSet())).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((DeclaredType)Iterables.getOnlyElement((Iterable)enclosedCreators), this.elements, this.types, this.dependencyRequestFactory));
        ImmutableSet scopes = Scopes.scopesOf(typeElement2);
        if (componentAnnotation.isProduction()) {
            scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.elements)).build();
        }
        return new AutoValue_ComponentDescriptor(componentAnnotation, typeElement2, (ImmutableSet<ComponentRequirement>)componentDependencies, transitiveModules, (ImmutableMap<ExecutableElement, ComponentRequirement>)dependenciesByDependencyMethod.build(), (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.build(), (ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.build(), (ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor>)builder.build(), creatorDescriptor);
    }

    private ComponentDescriptor.ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, ComponentAnnotation componentAnnotation, ExecutableElement componentMethod) {
        ComponentDescriptor.ComponentMethodDescriptor.Builder descriptor2 = ComponentDescriptor.ComponentMethodDescriptor.builder(componentMethod);
        ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
        TypeMirror returnType2 = resolvedComponentMethod.getReturnType();
        if (returnType2.getKind().equals((Object)TypeKind.DECLARED) && !this.injectionAnnotations.getQualifier(componentMethod).isPresent()) {
            TypeElement returnTypeElement = MoreTypes.asTypeElement(returnType2);
            if (ComponentAnnotation.subcomponentAnnotation(returnTypeElement).isPresent()) {
                return descriptor2.subcomponent(this.subcomponentDescriptor(returnTypeElement)).build();
            }
            if (ConfigurationAnnotations.isSubcomponentCreator(returnTypeElement)) {
                descriptor2.subcomponent(this.subcomponentDescriptor(MoreElements.asType(returnTypeElement.getEnclosingElement())));
            }
        }
        switch (componentMethod.getParameters().size()) {
            case 0: {
                Preconditions.checkArgument((!returnType2.getKind().equals((Object)TypeKind.VOID) ? 1 : 0) != 0, (String)"component method cannot be void: %s", (Object)componentMethod);
                descriptor2.dependencyRequest(componentAnnotation.isProduction() ? this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod) : this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            case 1: {
                Preconditions.checkArgument((returnType2.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType2, (Object)resolvedComponentMethod.getParameterTypes().get(0)) ? 1 : 0) != 0, (String)"members injection method must return void or parameter type: %s", (Object)componentMethod);
                descriptor2.dependencyRequest(this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                break;
            }
            default: {
                throw new IllegalArgumentException("component method has too many parameters: " + componentMethod);
            }
        }
        return descriptor2.build();
    }
}

