/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.Key;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public final class SubcomponentNames {
    private static final Splitter QUALIFIED_NAME_SPLITTER = Splitter.on((char)'.');
    private final ImmutableMap<ComponentDescriptor, String> namesByDescriptor;
    private final ImmutableMap<Key, ComponentDescriptor> descriptorsByCreatorKey;

    public SubcomponentNames(BindingGraph graph, KeyFactory keyFactory) {
        this.namesByDescriptor = SubcomponentNames.namesByDescriptor(graph);
        this.descriptorsByCreatorKey = SubcomponentNames.descriptorsByCreatorKey(keyFactory, (ImmutableSet<ComponentDescriptor>)this.namesByDescriptor.keySet());
    }

    String get(ComponentDescriptor componentDescriptor) {
        return (String)this.namesByDescriptor.get((Object)componentDescriptor);
    }

    String getCreatorName(Key key) {
        return this.getCreatorName((ComponentDescriptor)this.descriptorsByCreatorKey.get((Object)key));
    }

    String getCreatorName(ComponentDescriptor componentDescriptor) {
        Preconditions.checkArgument((boolean)componentDescriptor.creatorDescriptor().isPresent());
        ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
        return this.get(componentDescriptor) + creatorDescriptor.kind().typeName();
    }

    private static ImmutableMap<ComponentDescriptor, String> namesByDescriptor(BindingGraph graph) {
        ImmutableListMultimap componentDescriptorsBySimpleName = Multimaps.index(graph.componentDescriptors(), SubcomponentNames::simpleName);
        LinkedHashMap subcomponentImplSimpleNames = new LinkedHashMap();
        componentDescriptorsBySimpleName.asMap().values().stream().map(SubcomponentNames::disambiguateConflictingSimpleNames).forEach(subcomponentImplSimpleNames::putAll);
        subcomponentImplSimpleNames.remove(graph.componentDescriptor());
        return ImmutableMap.copyOf(subcomponentImplSimpleNames);
    }

    private static ImmutableMap<Key, ComponentDescriptor> descriptorsByCreatorKey(KeyFactory keyFactory, ImmutableSet<ComponentDescriptor> subcomponents) {
        return (ImmutableMap)subcomponents.stream().filter(subcomponent -> subcomponent.creatorDescriptor().isPresent()).collect(DaggerStreams.toImmutableMap(subcomponent -> keyFactory.forSubcomponentCreator(subcomponent.creatorDescriptor().get().typeElement().asType()), subcomponent -> subcomponent));
    }

    private static ImmutableMap<ComponentDescriptor, String> disambiguateConflictingSimpleNames(Collection<ComponentDescriptor> componentsWithConflictingNames) {
        if (componentsWithConflictingNames.size() == 1) {
            ComponentDescriptor component = (ComponentDescriptor)Iterables.getOnlyElement(componentsWithConflictingNames);
            return ImmutableMap.of((Object)component, (Object)SubcomponentNames.simpleName(component));
        }
        UniqueNameSet nameSet = new UniqueNameSet();
        ImmutableMap.Builder uniqueNames = ImmutableMap.builder();
        for (ComponentDescriptor component : componentsWithConflictingNames) {
            String simpleName = SubcomponentNames.simpleName(component);
            String basePrefix = SubcomponentNames.uniquingPrefix(component);
            uniqueNames.put((Object)component, (Object)String.format("%s_%s", nameSet.getUniqueName(basePrefix), simpleName));
        }
        return uniqueNames.build();
    }

    private static String simpleName(ComponentDescriptor component) {
        return component.typeElement().getSimpleName().toString();
    }

    private static String uniquingPrefix(ComponentDescriptor component) {
        TypeElement typeElement = component.typeElement();
        String containerName = typeElement.getEnclosingElement().getSimpleName().toString();
        if (!containerName.isEmpty() && Character.isUpperCase(containerName.charAt(0))) {
            return CharMatcher.javaLowerCase().removeFrom((CharSequence)containerName);
        }
        Name qualifiedName = typeElement.getQualifiedName();
        Iterator pieces = QUALIFIED_NAME_SPLITTER.split((CharSequence)qualifiedName).iterator();
        StringBuilder b = new StringBuilder();
        while (pieces.hasNext()) {
            String next = (String)pieces.next();
            if (!pieces.hasNext()) continue;
            b.append(next.charAt(0));
        }
        return b.length() > 0 ? b.toString() : "$";
    }
}

