/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.model.RequestKind;

public enum FrameworkTypeMapper {
    FOR_PROVIDER{

        @Override
        public FrameworkType getFrameworkType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return FrameworkType.PROVIDER;
                }
                case PRODUCED: 
                case PRODUCER: {
                    throw new IllegalArgumentException(requestKind.toString());
                }
            }
            throw new AssertionError(requestKind);
        }
    }
    ,
    FOR_PRODUCER{

        @Override
        public FrameworkType getFrameworkType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PRODUCED: 
                case PRODUCER: {
                    return FrameworkType.PRODUCER_NODE;
                }
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return FrameworkType.PROVIDER;
                }
            }
            throw new AssertionError(requestKind);
        }
    };


    public static FrameworkTypeMapper forBindingType(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? FOR_PRODUCER : FOR_PROVIDER;
    }

    public abstract FrameworkType getFrameworkType(RequestKind var1);
}

