/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;

public enum ModuleKind {
    MODULE(Module.class),
    PRODUCER_MODULE(ProducerModule.class);

    private final Class<? extends Annotation> moduleAnnotation;

    public static ImmutableSet<Class<? extends Annotation>> annotationsFor(Set<ModuleKind> kinds) {
        return (ImmutableSet)kinds.stream().map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ModuleKind> forAnnotatedElement(TypeElement element) {
        EnumSet<ModuleKind> kinds = EnumSet.noneOf(ModuleKind.class);
        for (ModuleKind kind : ModuleKind.values()) {
            if (!MoreElements.isAnnotationPresent(element, kind.annotation())) continue;
            kinds.add(kind);
        }
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ModuleKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    public static void checkIsModule(TypeElement moduleElement, KotlinMetadataUtil metadataUtil) {
        if (metadataUtil.isCompanionObjectClass(moduleElement)) {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(MoreElements.asType(moduleElement.getEnclosingElement())).isPresent());
        } else {
            Preconditions.checkArgument((boolean)ModuleKind.forAnnotatedElement(moduleElement).isPresent());
        }
    }

    private ModuleKind(Class<? extends Annotation> moduleAnnotation) {
        this.moduleAnnotation = moduleAnnotation;
    }

    public AnnotationMirror getModuleAnnotation(TypeElement element) {
        Optional<AnnotationMirror> result = DaggerElements.getAnnotationMirror(element, this.moduleAnnotation);
        Preconditions.checkArgument((boolean)result.isPresent(), (String)"annotation %s is not present on type %s", this.moduleAnnotation, (Object)element);
        return result.get();
    }

    public Class<? extends Annotation> annotation() {
        return this.moduleAnnotation;
    }

    public ImmutableSet<ModuleKind> legalIncludedModuleKinds() {
        switch (this) {
            case MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[0]);
            }
            case PRODUCER_MODULE: {
                return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new ModuleKind[]{PRODUCER_MODULE});
            }
        }
        throw new AssertionError((Object)this);
    }
}

