/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.DelegateFactory;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkField;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.producers.internal.DelegateProducer;
import java.util.Optional;
import javax.lang.model.element.Modifier;

class FrameworkFieldInitializer
implements FrameworkInstanceSupplier {
    private final ComponentImplementation componentImplementation;
    private final ContributionBinding binding;
    private final FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
    private FieldSpec fieldSpec;
    private InitializationState fieldInitializationState = InitializationState.UNINITIALIZED;

    FrameworkFieldInitializer(ComponentImplementation componentImplementation, ContributionBinding binding, FrameworkInstanceCreationExpression frameworkInstanceCreationExpression) {
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.frameworkInstanceCreationExpression = (FrameworkInstanceCreationExpression)Preconditions.checkNotNull((Object)frameworkInstanceCreationExpression);
    }

    @Override
    public final MemberSelect memberSelect() {
        this.initializeField();
        return MemberSelect.localField(this.componentImplementation.name(), ((FieldSpec)Preconditions.checkNotNull((Object)this.fieldSpec)).name);
    }

    private void initializeField() {
        switch (this.fieldInitializationState) {
            case UNINITIALIZED: {
                this.fieldInitializationState = InitializationState.INITIALIZING;
                CodeBlock.Builder codeBuilder = CodeBlock.builder();
                CodeBlock fieldInitialization = this.frameworkInstanceCreationExpression.creationExpression();
                CodeBlock initCode = CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{this.getOrCreateField(), fieldInitialization});
                if (this.fieldInitializationState == InitializationState.DELEGATED) {
                    codeBuilder.add("$T.setDelegate($N, $L);", new Object[]{this.delegateType(), this.fieldSpec, fieldInitialization});
                } else {
                    codeBuilder.add(initCode);
                }
                this.componentImplementation.addInitialization(codeBuilder.build());
                this.fieldInitializationState = InitializationState.INITIALIZED;
                break;
            }
            case INITIALIZING: {
                this.fieldInitializationState = InitializationState.DELEGATED;
                this.componentImplementation.addInitialization(CodeBlock.of((String)"this.$N = new $T<>();", (Object[])new Object[]{this.getOrCreateField(), this.delegateType()}));
                break;
            }
        }
    }

    private FieldSpec getOrCreateField() {
        if (this.fieldSpec != null) {
            return this.fieldSpec;
        }
        boolean useRawType = !this.componentImplementation.isTypeAccessible(this.binding.key().type());
        FrameworkField contributionBindingField = FrameworkField.forBinding(this.binding, this.frameworkInstanceCreationExpression.alternativeFrameworkClass());
        ParameterizedTypeName fieldType = useRawType ? contributionBindingField.type().rawType : contributionBindingField.type();
        FieldSpec.Builder contributionField = FieldSpec.builder((TypeName)fieldType, (String)this.componentImplementation.getUniqueFieldName(contributionBindingField.name()), (Modifier[])new Modifier[0]);
        contributionField.addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (useRawType) {
            contributionField.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
        }
        this.fieldSpec = contributionField.build();
        this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, this.fieldSpec);
        return this.fieldSpec;
    }

    private Class<?> delegateType() {
        return this.isProvider() ? DelegateFactory.class : DelegateProducer.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProvider() {
        if (!this.binding.bindingType().equals((Object)BindingType.PROVISION)) return false;
        if (this.frameworkInstanceCreationExpression.alternativeFrameworkClass().map(arg_0 -> ((ClassName)TypeNames.PROVIDER).equals(arg_0)).orElse(true) == false) return false;
        return true;
    }

    private static enum InitializationState {
        UNINITIALIZED,
        INITIALIZING,
        DELEGATED,
        INITIALIZED;

    }

    static interface FrameworkInstanceCreationExpression {
        public CodeBlock creationExpression();

        default public Optional<ClassName> alternativeFrameworkClass() {
            return Optional.empty();
        }

        default public boolean useInnerSwitchingProvider() {
            return true;
        }
    }
}

